package csbase.client.applications.flowapplication;

import tecgraf.javautils.gui.tree.DefaultNode;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * N Verso do Algoritmo.
 * 
 * @author lmoreira
 */
public class AlgorithmVersionTreeNode extends DefaultNode implements
  Comparable<AlgorithmVersionTreeNode> {
  /**
   * A verso do algoritmo.
   */
  private final AlgorithmVersionInfo algorithmVersion;

  /**
   * Cria o n.
   * 
   * @param algorithmVersionInfo A verso do algoritmo (No aceita {@code null}
   *        ).
   */
  public AlgorithmVersionTreeNode(
    final AlgorithmVersionInfo algorithmVersionInfo) {
    super(algorithmVersionInfo.getId().toString(), FiltrageMode.IGNORE);
    this.algorithmVersion = algorithmVersionInfo;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int compareTo(final AlgorithmVersionTreeNode node) {
    return getAlgorithmVersion().compareTo(node.getAlgorithmVersion());
  }

  /**
   * Obtm a verso do algoritmo.
   * 
   * @return A verso do algoritmo.
   */
  public AlgorithmVersionInfo getAlgorithmVersion() {
    return this.algorithmVersion;
  }
}
