package csbase.client.applications.flowapplication.multiflow.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.tree.DefaultMutableTreeNode;

import csbase.logic.algorithms.flows.FlowNode;

/**
 * N da rvore de seleo de parmetros que representa um algoritmo.
 */
public class AlgorithmNode extends DefaultMutableTreeNode implements
  ParameterSelectionNode {

  /**
   * Construtor.
   * 
   * @param flowNode n do fluxo (algoritmo).
   */
  public AlgorithmNode(FlowNode flowNode) {
    super(flowNode, true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public FlowNode getUserObject() {
    return (FlowNode) super.getUserObject();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<ParameterSelection> getParameterSelection() {
    List<ParameterSelection> selection = new ArrayList<ParameterSelection>();
    for (Object child : children) {
      ParameterNode parameterNode = (ParameterNode) child;
      Collection<ParameterSelection> parameterSelection =
        parameterNode.getParameterSelection();
      selection.addAll(parameterSelection);
    }
    return selection;
  }

}
