/*
 * $Id:$
 */

package csbase.client.applications.xmlviewer.actions.core;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.xmlviewer.XMLViewer;

/**
 * @author Tecgraf/PUC-Rio
 */
abstract public class XMLViewerAction extends
  AbstractSimpleApplicationAction<XMLViewer> {

  /**
   * Construtor
   * 
   * @param application aplicao
   */
  protected XMLViewerAction(XMLViewer application) {
    super(application);
  }

  /**
   * Construtor
   * 
   * @param application aplicao
   * @param icon cone
   */
  public XMLViewerAction(XMLViewer application, ImageIcon icon) {
    super(application, icon);
  }

  /**
   * Resultado da ao encapsulada do Java.
   * 
   * @param ae evento Java
   * @see #actionDone(JComponent)
   */
  @Override
  final public void handleActionPerformed(final ActionEvent ae) {
    try {
      final JComponent cmp = (ae == null ? null : (JComponent) ae.getSource());
      actionDone(cmp);
    }
    catch (Exception e) {
      final XMLViewer application = getApplication();
      application.handleException(e);
    }
  }

  /**
   * Ao.
   * 
   * @param component componente Swing
   * @throws Exception em caso de falha.
   */
  abstract public void actionDone(JComponent component) throws Exception;

}
