/**
 * $Id: NotificationRecipientsTableModel.java 150777 2014-03-19 14:16:56Z oikawa $
 */
package csbase.client.desktop;

import java.util.ArrayList;
import java.util.List;

import javax.swing.table.DefaultTableModel;

import tecgraf.javautils.core.lng.LNG;
import csbase.logic.UserOutline;

/**
 * Modelo para a tabela de destinatrios da tela de envio de notificaes.
 * 
 * @author Tecgraf
 */
class NotificationRecipientsTableModel extends DefaultTableModel {
  /**
   * ndice da coluna com o login.
   */
  private static final int COL_LOGIN = 0;
  /**
   * ndice da coluna com o nome.
   */
  private static final int COL_NAME = 1;
  /**
   * ndice da coluna com o grupo.
   */
  private static final int COL_GROUP = 2;

  /**
   * Nomes das colunas da tabela.
   */
  private static final String[] COLUMN_NAMES = {
      LNG.get("NotificationRecipientsTableModel.header.login"),
      LNG.get("NotificationRecipientsTableModel.header.name"),
      LNG.get("NotificationRecipientsTableModel.header.group") };

  /**
   * Lista de usurios.
   */
  private List<UserOutline> users;

  /**
   * Construtor.
   * 
   * @param users lista de usurios
   */
  NotificationRecipientsTableModel(List<UserOutline> users) {
    this.users = users;
  }

  /**
   * Construtor (tabela vazia).
   */
  public NotificationRecipientsTableModel() {
    this(new ArrayList<UserOutline>());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getColumnCount() {
    return COLUMN_NAMES.length;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName(int column) {
    return COLUMN_NAMES[column];
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getRowCount() {
    return users == null ? 0 : users.size();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValueAt(int row, int column) {
    UserOutline user = users.get(row);
    switch (column) {
      case COL_LOGIN:
        return user.getLogin();

      case COL_NAME:
        return user.getName();

      case COL_GROUP:
        return user.getUserGroup();

      default:
        throw new RuntimeException("coluna invlida: " + column);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isCellEditable(int row, int column) {
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass(int columnIndex) {
    return String.class;
  }

  /**
   * Obtm os IDs para os usurios associados a determinados ndices.
   * <p>
   * Os ndices devem ndices <b>do modelo</b>.
   * 
   * @param selectedRows ndices <b>do modelo</b>
   * 
   * @return IDs dos usurios associados aos ndices
   */
  List<Object> getIDsFor(int[] selectedRows) {
    List<Object> ids = new ArrayList<Object>(selectedRows.length);
    for (int i : selectedRows) {
      ids.add(users.get(i).getId());
    }
    return ids;
  }

  /**
   * Atualiza a lista de usurios.
   * 
   * @param users lista de usurios
   * @param oldSelectedIndexes ndices selecionados no modelo antigo
   * @return ndices dos elementos selecionados no novo modelo
   */
  List<Integer> setUsers(List<UserOutline> users, int[] oldSelectedIndexes) {
    List<Integer> newSelectedIndexes = new ArrayList<Integer>();
    if (oldSelectedIndexes != null) {
      List<UserOutline> selectedUsers =
        new ArrayList<UserOutline>(oldSelectedIndexes.length);
      /*
       * coletamos os usurios associados aos ndices
       */
      for (int i : oldSelectedIndexes) {
        if (i < users.size()) {
          selectedUsers.add(users.get(i));
        }
      }
      /*
       * agora criamos uma nova lista com os ndices associados aos mesmos
       * usurios, sobre o novo modelo
       */
      for (UserOutline userOutline : selectedUsers) {
        newSelectedIndexes.add(users.indexOf(userOutline));
      }
    }
    this.users = users;
    fireTableDataChanged();

    return newSelectedIndexes;
  }

  /**
   * Define uma lista vazia de usurios.
   */
  void setUsers() {
    setUsers(new ArrayList<UserOutline>(), null);
  }
}
