package csbase.client.facilities.configurabletable.table;

/**
 * Interface que define como obter uma chave (String) de uma linha genrica do
 * tipo T. Essa interface  til quando queremos dizer as tabelas configurveis
 * como manter as mesmas linhas selecionadas aps uma atualizao das linhas.
 * 
 * @param <T> - tipo da objeto que implementa a linha.
 * 
 * @author Tecgraf
 */
public interface RowToKey<T> {

  /**
   * Obtm a chave (String) de uma linha genrica.
   * 
   * @param row - linha.
   * 
   * @return chave que descreve a linha.
   */
  String getKey(T row);
}
