package csbase.client.openbus;

import csbase.client.applications.desktoplauncher.DesktopLauncher;

/**
 * Eventos standard para clientes CSBASE cjuo tipo (type)  determinado pelo
 * nome da enumerao.
 * 
 * @author Tecgraf/PUC-Rio
 */
public enum OpenBusStandardEvents {

  /**
   * Pedido de abertura de projeto no desktop (valor string enviado
   * representando o id do projeto); ver relao com
   * {@link #PRJ_CLOSE_INFO} e {@link #PRJ_OPEN_INFO}.
   */
  PRJ_OPEN_REQ,

  /**
   * Resposta de abertura de projeto no desktop (valor string enviado
   * representando o id do projeto); ver relao com
   * {@link #PRJ_OPEN_REQ}.
   */
  PRJ_OPEN_SUCCESS_RSP,

  /**
   * Resposta negativa de abertura de projeto no desktop (valor string enviado
   * representando o id do projeto); ver relao com
   * {@link #PRJ_OPEN_REQ}.
   */
  PRJ_OPEN_FAILED_RSP,

  /**
   * Pedido de fechamento de projeto no desktop; ver relao com
   * {@link #PRJ_CLOSE_INFO} e {@link #PRJ_OPEN_INFO}.
   */
  PRJ_CLOSE_REQ,
  
  /**
   * Pedido de fechamento de projeto no desktop; ver relao com
   * {@link #PRJ_CLOSE_REQ}.
   */
  PRJ_CLOSE_RSP,

  /**
   * Informao de projeto fechado do desktop; ver relao com
   * {@link #PRJ_OPEN_INFO}
   */
  PRJ_CLOSE_INFO,

  /**
   * Informao de projeto aberto do desktop (valor string enviado representando
   * o id/nome do projeto); ver relao com {@link #PRJ_CLOSE_INFO} e
   * {@link #PRJ_OPEN_REQ}
   */
  PRJ_OPEN_INFO,

  /**
   * Pedido de lanamento de aplicativo no desktop (valor string enviado
   * representando o id da aplicao a ser lanada); ver relao com
   * {@link #APP_EXECUTION_FAILURE_RSP} e {@link #APP_EXECUTION_SUCCESS_RSP}.
   */
  APP_EXECUTION_REQ,

  /**
   * Resposta positiva de lanamento de aplicativo no desktop (valor string
   * enviado representando o id da aplicaco e um identificador da instncia da
   * aplicao separados por ":"); ver relao com {@link #APP_EXECUTION_REQ}
   */
  APP_EXECUTION_SUCCESS_RSP,

  /**
   * Resposta negativa de lanamento de aplicativo no desktop (valor string
   * enviado representando o id da aplicao); ver relao com
   * {@link #APP_EXECUTION_REQ}
   */
  APP_EXECUTION_FAILURE_RSP,

  /**
   * Informativo de ativao um aplicativo do tipo {@link DesktopLauncher}
   * (disparador de desktops) - sem valor enviado; ver relao com
   * {@link #DSKLAUNCHER_END_INFO}
   */
  DSKLAUNCHER_START_INFO,

  /**
   * Informativo de ativao um aplicativo do tipo {@link DesktopLauncher}
   * (disparador de desktops); ver relao com {@link #DSKLAUNCHER_START_INFO}
   */
  DSKLAUNCHER_END_INFO,

  /**
   * Pedido de visibilidade de desktop (valor booleano enviado com indicativo de
   * visibilidade).
   */
  DESKTOP_VISIBILITY_REQ,

  /**
   * Informativo de visibilidade de desktop (valor booleano enviado com indicativo de
   * visibilidade).
   */
  DESKTOP_VISIBILITY_INFO,

  /**
   * Informativo de aparecimento de desktop (sem valor enviado); ver relao com
   * {@link #DESKTOP_END_INFO}
   */
  DESKTOP_START_INFO,

  /**
   * Requisio de shutdown de desktop (sem valor enviado).
   */
  DESKTOP_SHUTDOWN_REQ,

  /**
   * Informativo de finalizao de desktop (sem valor enviado); ver relao com
   * {@link #DESKTOP_START_INFO}
   */
  DESKTOP_END_INFO;

  /**
   * Indica se um tipo de evento  predefinido (deste tipo especfico).
   * 
   * @param type tipo questionado.
   * @return indicativo.
   */
  final public boolean isMyType(final String type) {
    if (type == null) {
      return false;
    }

    final String trimmedType = type.trim();
    final String myType = name();
    if (trimmedType.equals(myType)) {
      return true;
    }
    return false;
  }

  /**
   * Mtodo utilitrio de envio de evento.
   * 
   * @param eventHandler tratador de eventos a ser usado.
   * @param destId destino
   * @param value valor (infomao)
   * @return indicativo de tratamento.
   */
  final public boolean sendEvent(OpenBusEventHandler eventHandler,
    final String destId, Object value) {
    final String sourceId = eventHandler.getClientInstanceId();

    final String type = name();
    if (value == null) {
      return eventHandler.sendEventWithNoValue(sourceId, destId, type);
    }
    if (value instanceof String) {
      final String stringValue = (String) value;
      return eventHandler.sendEventWithStringValue(sourceId, destId, type,
        stringValue);
    }
    if (value instanceof Boolean) {
      final Boolean booleanValue = (Boolean) value;
      return eventHandler.sendEventWithBooleanValue(sourceId, destId, type,
        booleanValue);
    }
    final String className = this.getClass().getName();
    final String typeName = value.getClass().getName();
    System.out.println("!!! FALHA DE TIPO: " + className + " / " + typeName);
    return false;
  }
}
