/*
 * $Id: CommonFileOpenAction.java 150777 2014-03-19 14:16:56Z oikawa $
 */
package csbase.client.project.action;

import java.awt.Window;
import java.awt.event.ActionEvent;

import javax.swing.Action;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.resourcehelpers.ApplicationUtils;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectFileContainer;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;

/**
 * Ao usada para abrir um determinado tipo de arquivo em uma aplicao. 
 * possvel definirmos explicitamente qual a aplicao que deve ser usada para
 * exibir um determinado arquivo. Caso no seja informado a aplicao, esta ao
 * usar a aplicao preferncial definida nas preferncias do usurio.
 */
public class CommonFileOpenAction extends CommonProjectAction {

  /**
   * Identificador da aplicao que ir abrir o arquivo selecionado.
   */
  private String applicationId;

  /**
   * Nome da ao
   */
  private String name;

  /**
   * Constri a ao com uma aplicao padro para abrir arquivos.
   * 
   * @param container formato de dados que representa um
   *        <code>ProjectFile</code>.
   * @param applicationId identificador da aplicao que ir abrir o arquivo
   *        selecionado
   * @param name nome da ao
   */
  public CommonFileOpenAction(ProjectFileContainer container,
    String applicationId, String name) {
    super(container);
    this.applicationId = applicationId;
    this.name = name;
    putValue(Action.NAME, name);
  }

  /**
   * Constri a ao sem uma aplicao para abrir arquivos. Neste caso, ser
   * usado a aplicao preferncial definida nas preferncias do usurio.
   * 
   * @param container formato de dados que representa um
   *        <code>ProjectFile</code>.
   */
  public CommonFileOpenAction(ProjectFileContainer container) {
    super(container);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    openFile(getSelectedFile());
  }

  /**
   * Abre o arquivo na aplicao.
   * 
   * @param file arquivo a ser aberto
   */
  public void openFile(ClientProjectFile file) {
    try {
      Window owner = DesktopFrame.getInstance().getDesktopFrame();
      if (applicationId != null) {
        ApplicationUtils.runApp(applicationId, owner, file);
      }
      else {
        ApplicationUtils.runPreferredApp(owner, file);
      }
    }
    catch (ApplicationException ex) {
      StandardErrorDialogs.showErrorDialog(getWindow(), ex.getMessage(), ex);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    if (name == null) {
      return LNG.get("CommonFileOpenAction.name");
    }
    return name;
  }

}
