package csbase.client.util.table;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/**
 * Fbrica de Vises de Clulas que utiliza Reflexo: ela cria vises de clulas
 * atravs de reflexo. Ao criar a fbrica o usurio deve informar qual  a
 * classe do objeto armazenado na linha e da viso de clulas a ser criada. Ela
 * procura um construtor que no receba parmetros e invoca este construtor na
 * criao dos modelos de clulas.
 */
public final class ReflectionCellViewFactory implements CellViewFactory {

  /**
   * O construtor de vises de clulas.
   */
  private Constructor<? extends CellView> cellViewClassConstrutor;

  /**
   * Cria a fbrica.
   * 
   * @param cellViewClass A classe da viso de clulas.
   */
  public ReflectionCellViewFactory(Class<? extends CellView> cellViewClass) {
    if (cellViewClass == null) {
      throw new IllegalArgumentException("O parmetro cellViewClass est nulo.");
    }
    try {
      this.cellViewClassConstrutor = cellViewClass.getConstructor();
    } catch (NoSuchMethodException e) {
      throw new IllegalArgumentException(e);
    }
  }

  public CellView create() {
    try {
      return cellViewClassConstrutor.newInstance();
    } catch (InstantiationException e) {
      throw new IllegalStateException(e);
    } catch (IllegalAccessException e) {
      throw new IllegalStateException(e);
    } catch (InvocationTargetException e) {
      throw new IllegalStateException(e);
    }
  }
}
