/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager;

import csbase.client.applicationmanager.ApplicationStartAction;
import csbase.client.applicationmanager.Utilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class ApplicationLink
extends JLabel {
    private static final Border FOCUS_BORDER = ApplicationLink.createBorder(Color.GRAY);
    private static final Border NO_BORDER = ApplicationLink.createBorder(new JLabel().getBackground());
    private static final String POS_X_INFO = "POS_X_INFO";
    private static final int DEFAULT_POS_X = 0;
    private static final String POS_Y_INFO = "POS_Y_INFO";
    private static final int DEFAULT_POS_Y = 0;
    private final ApplicationStartAction action;

    private static Border createBorder(Color color) {
        int i = 2;
        int e = 4;
        Border external = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        Border internal = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        Border line = BorderFactory.createLineBorder(color);
        CompoundBorder brd = BorderFactory.createCompoundBorder(external, BorderFactory.createCompoundBorder(line, internal));
        return brd;
    }

    public ImageIcon getImageIcon() {
        return (ImageIcon)this.getIcon();
    }

    public void setInfo(Hashtable<String, Integer> appInfo) {
        int x = Utilities.getIntegerFromHash(appInfo, POS_X_INFO, 0);
        int y = Utilities.getIntegerFromHash(appInfo, POS_Y_INFO, 0);
        this.setLocation(x, y);
    }

    public Hashtable<String, Integer> getInfo() {
        Hashtable<String, Integer> appInfo = new Hashtable<String, Integer>();
        appInfo.put(POS_X_INFO, this.getX());
        appInfo.put(POS_Y_INFO, this.getY());
        return appInfo;
    }

    public void executeAction() {
        this.action.actionPerformed(new ActionEvent(this, 0, ""));
    }

    public ApplicationLink(ApplicationStartAction action) {
        this.action = action;
        Object acName = action.getValue("Name");
        String actionName = acName == null ? "???" : (String)acName;
        this.setText(actionName);
        ApplicationRegistry registry = action.getApplicationRegistry();
        byte[] acImg = registry.getImageDefinition();
        if (acImg != null) {
            this.setIcon(new ImageIcon(acImg));
        }
        this.setOpaque(false);
        this.setFont(new Font("SansSerif", 0, 12));
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setBorder(NO_BORDER);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                if (ev.getClickCount() == 2) {
                    try {
                        if (ApplicationLink.this.isEnabled()) {
                            ApplicationLink.this.executeAction();
                        }
                    }
                    catch (Exception ce) {
                        StandardErrorDialogs.showErrorDialog(null, ce);
                    }
                }
            }
        });
        this.setLocation(50, 50);
        this.setOpaque(false);
        this.setVisible(true);
        Dimension preferredSize = this.getPreferredSize();
        this.setPreferredSize(preferredSize);
        ApplicationLinkMouseListener listener = new ApplicationLinkMouseListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    private static class ApplicationLinkMouseListener
    extends MouseAdapter {
        final JComponent draggedComponent;
        Point origin = null;

        @Override
        public void mousePressed(MouseEvent ev) {
            this.origin = ev.getPoint();
            this.draggedComponent.setBorder(FOCUS_BORDER);
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            this.origin = null;
            this.draggedComponent.setBorder(NO_BORDER);
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            int parentHeight;
            int myHeight;
            int parentWidth;
            if (this.origin == null) {
                return;
            }
            Point p = this.draggedComponent.getLocation();
            double dx = (double)ev.getX() - this.origin.getX();
            double dy = (double)ev.getY() - this.origin.getY();
            p.translate((int)dx, (int)dy);
            if (p.x < 0) {
                p.x = 0;
            }
            if (p.y < 0) {
                p.y = 0;
            }
            Container parent = this.draggedComponent.getParent();
            int myWidth = this.draggedComponent.getWidth();
            if (p.x + myWidth > (parentWidth = parent.getWidth())) {
                p.x = parentWidth - myWidth;
            }
            if (p.y + (myHeight = this.draggedComponent.getHeight()) > (parentHeight = parent.getHeight())) {
                p.y = parentHeight - myHeight;
            }
            this.draggedComponent.setLocation(p);
            this.draggedComponent.getParent().setLayout(null);
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
        }

        ApplicationLinkMouseListener(JComponent c) {
            this.draggedComponent = c;
        }
    }
}

