/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.ApplicationTask;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectFileChooserOpen;
import csbase.client.project.ProjectFileChooserSave;
import csbase.client.project.ProjectTreePath;
import csbase.client.project.tasks.CreateFileTask;
import csbase.client.project.tasks.GetChildFromNameTask;
import csbase.client.project.tasks.GetChildFromPathTask;
import csbase.client.project.tasks.SetFileTypeTask;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.exception.CSBaseRuntimeException;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.awt.Window;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.core.lng.LNG;

public abstract class ApplicationProject
extends Application {
    protected ApplicationProject(String id) {
        super(id);
    }

    public final ClientProjectFile browseFileOpenFromProject(CommonClientProject project, String[] fileTypes, String defaultType, Window frame) throws ApplicationException {
        boolean useNewChooser = this.useNewChooser();
        if (useNewChooser) {
            return this.newBrowseFileOpenFromProject(project, fileTypes, defaultType, frame);
        }
        return this.oldBrowseFileOpenFromProject(project, fileTypes, defaultType, frame);
    }

    private boolean useNewChooser() {
        try {
            ConfigurationManager cnfManager = ConfigurationManager.getInstance();
            Configuration cnf = cnfManager.getConfiguration(ApplicationProject.class);
            String propName = "new.chooser";
            Boolean newChooser = cnf.getOptionalBooleanProperty("new.chooser", false);
            return newChooser;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ClientProjectFile newBrowseFileOpenFromProject(CommonClientProject project, String[] fileTypes, String defaultType, Window window) {
        ArrayList<String> types = new ArrayList<String>();
        for (String fileType : fileTypes) {
            types.add(fileType);
        }
        ClientProjectFileChooserUtil.OperationResult result = ClientProjectFileChooserUtil.browseSingleFileInOpenMode(window, types, "", true);
        if (result == null) {
            return null;
        }
        ClientProjectFile clientProjectFile = result.getClientProjectFile();
        return clientProjectFile;
    }

    private ClientProjectFile oldBrowseFileOpenFromProject(CommonClientProject project, String[] fileTypes, String defaultType, Window frame) throws ApplicationException {
        ProjectFileChooserOpen selection;
        try {
            selection = new ProjectFileChooserOpen(frame, project, false, fileTypes, defaultType);
        }
        catch (ClientException e) {
            throw new ApplicationException(e);
        }
        ProjectTreePath treePath = selection.getSelectedPath();
        if (treePath == null) {
            return null;
        }
        return treePath.getFile();
    }

    public final ClientProjectFile browseFileOpen(String[] fileTypes, String defaultType, Window frame) throws ApplicationException {
        CommonClientProject project = this.getApplicationProject();
        return this.browseFileOpenFromProject(project, fileTypes, defaultType, frame);
    }

    public final ClientProjectFile browseFileOpen(String[] fileTypes, String defaultType) throws ApplicationException {
        return this.browseFileOpen(fileTypes, defaultType, this.getApplicationFrame());
    }

    public final ClientProjectFile browseFileOpen(String fileType) throws ApplicationException {
        return this.browseFileOpen(new String[]{fileType}, fileType);
    }

    public final ClientProjectFile browseFileOpen(String fileType, Window frame) throws ApplicationException {
        return this.browseFileOpen(new String[]{fileType}, fileType, frame);
    }

    public final ClientProjectFile browseFileSaveFromProject(CommonClientProject project, String fileType, String fileExtension, String defaultName, Window window) throws ApplicationException {
        return this.browseFileSaveFromProject(project, fileType, fileExtension, defaultName, null, window);
    }

    public final ClientProjectFile browseFileSaveFromProject(CommonClientProject project, String fileType, String fileExtension, String defaultName, String[] currentDirectory, Window window) throws ApplicationException {
        if (this.useNewChooser()) {
            return this.newBrowseFileSaveFromProject(project, fileType, fileExtension, defaultName, currentDirectory, window);
        }
        return this.oldBrowseFileSaveFromProject(project, fileType, fileExtension, defaultName, currentDirectory, window);
    }

    private ClientProjectFile newBrowseFileSaveFromProject(CommonClientProject project, String fileType, String fileExtension, String defaultName, String[] currentDirectory, Window window) {
        ArrayList<String> types = new ArrayList<String>();
        types.add(fileType);
        ClientProjectFileChooserUtil.OperationResult result = ClientProjectFileChooserUtil.browseSingleFileInSaveMode(window, types, fileType, "", true, true);
        if (result == null) {
            return null;
        }
        ClientProjectFile clientProjectFile = result.getClientProjectFile();
        return clientProjectFile;
    }

    private ClientProjectFile oldBrowseFileSaveFromProject(CommonClientProject project, String fileType, String fileExtension, String defaultName, String[] currentDirectory, Window frame) throws ApplicationException {
        ProjectFileChooserSave selection;
        try {
            selection = new ProjectFileChooserSave(frame, project, 0, fileType, defaultName, currentDirectory, fileExtension, false);
        }
        catch (ClientException e) {
            throw new ApplicationException(e);
        }
        return this.getFile(selection, project, fileExtension, frame);
    }

    private ClientProjectFile getFile(ProjectFileChooserSave saveSelection, CommonClientProject project, String fileExtension, Window frame) throws ApplicationException {
        ClientProjectFile parentDir;
        ClientProjectFile child;
        ProjectTreePath treePath = saveSelection.getSelectedPath();
        if (treePath == null || treePath.getPath() == null || treePath.getPath().length < 1) {
            return null;
        }
        String[] path = treePath.getPath();
        String name = path[path.length - 1];
        if (fileExtension != null) {
            String fileExt = fileExtension.replaceAll("^\\.*", "");
            String[] nameParts = name.split("\\.");
            if (nameParts.length > 1) {
                String ext = nameParts[nameParts.length - 1];
                if (!ext.toUpperCase().equals(fileExt.toUpperCase())) {
                    name = name + "." + fileExt;
                }
            } else {
                name = name + "." + fileExt;
            }
        }
        if ((child = GetChildFromNameTask.runTask(parentDir = treePath.getParent(), name)) != null) {
            String type = saveSelection.getFileType();
            if (!child.getType().equalsIgnoreCase(type)) {
                SetFileTypeTask fileTypeSetter = new SetFileTypeTask(child, type);
                fileTypeSetter.execute(frame, this.getName(), String.format(LNG.get((String)"applications.ApplicationProject.info.updating_file_type"), name));
            }
            return child;
        }
        CreateFileTask task = new CreateFileTask(project, treePath.getParent(), name, saveSelection.getFileType());
        boolean succeeded = task.execute(frame, this.getName(), String.format(LNG.get((String)"applications.ApplicationProject.info.creating_file"), name));
        Exception exception = task.getError();
        if (!(succeeded || exception instanceof CSBaseRuntimeException || exception instanceof RemoteException)) {
            throw new ApplicationException(exception);
        }
        return (ClientProjectFile)task.getResult();
    }

    public final ClientProjectFile browseFileSave(String fileType, Window frame) throws ApplicationException {
        CommonClientProject project = this.getApplicationProject();
        return this.browseFileSaveFromProject(project, fileType, null, null, frame);
    }

    public final ClientProjectFile browseFileSave(String fileType, String fileExtension, Window frame) throws ApplicationException {
        CommonClientProject project = this.getApplicationProject();
        return this.browseFileSaveFromProject(project, fileType, fileExtension, null, null, frame);
    }

    public final ClientProjectFile browseFileSave(String fileType, String fileExtension, String defaultName, Window frame) throws ApplicationException {
        return this.browseFileSave(fileType, fileExtension, defaultName, null, frame);
    }

    public final ClientProjectFile browseFileSave(String fileType, String fileExtension, String defaultName, String[] currentDirectory, Window frame) throws ApplicationException {
        CommonClientProject project = this.getApplicationProject();
        return this.browseFileSaveFromProject(project, fileType, fileExtension, defaultName, currentDirectory, frame);
    }

    public final ClientProjectFile browseFileSave(String fileType) throws ApplicationException {
        return this.browseFileSave(fileType, this.getApplicationFrame());
    }

    public final ClientProjectFile browseFileSave(String fileType, String fileExtension) throws ApplicationException {
        return this.browseFileSave(fileType, fileExtension, this.getApplicationFrame());
    }

    public final ClientProjectFile browseFileSave(String fileType, String fileExtension, String defaultName) throws ApplicationException {
        return this.browseFileSave(fileType, fileExtension, defaultName, this.getApplicationFrame());
    }

    public final String fileToString(ClientFile file) {
        if (file == null) {
            return "";
        }
        return file.getStringPath();
    }

    public final ClientProjectFile stringToFile(String path) {
        if (path == null) {
            throw new InvalidParameterException("Erro interno.\nPar\u00e2metro inv\u00e1lido em ApplicationProject.stringToFile");
        }
        String[] splitPath = ClientProjectFile.splitPath((String)path.trim());
        return this.stringArrayToFile(splitPath);
    }

    public final ClientProjectFile stringToFileWithCreation(String path, String type) {
        if (path == null) {
            throw new InvalidParameterException("Erro interno.\nPar\u00e2metro inv\u00e1lido em ApplicationProject.stringToFileWithCreation");
        }
        String[] splitPath = ClientProjectFile.splitPath((String)path.trim());
        return this.stringArrayToFileWithCreation(splitPath, type);
    }

    public final ClientProjectFile stringArrayToFile(String[] path) {
        if (path == null || path.length == 0) {
            throw new InvalidParameterException("Erro interno.\nPar\u00e2metro inv\u00e1lido em ApplicationProject.stringArrayToFile");
        }
        CommonClientProject project = this.getApplicationProject();
        ClientProjectFile root = project.getRoot();
        String[] rootPath = root.getPath();
        String[] fullPath = new String[rootPath.length + path.length];
        System.arraycopy(rootPath, 0, fullPath, 0, rootPath.length);
        System.arraycopy(path, 0, fullPath, rootPath.length, path.length);
        ClientProjectFile file = GetChildFromPathTask.runTask(root, fullPath);
        return file;
    }

    public final ClientProjectFile stringArrayToFileWithCreation(String[] path, final String type) {
        ClientProjectFile file = this.stringArrayToFile(path);
        if (file != null) {
            return file;
        }
        final CommonClientProject project = this.getApplicationProject();
        ClientProjectFile root = project.getRoot();
        final String name = path[path.length - 1];
        String[] rootPath = root.getPath();
        String[] dirPath = new String[rootPath.length + path.length - 1];
        System.arraycopy(rootPath, 0, dirPath, 0, rootPath.length);
        System.arraycopy(path, 0, dirPath, rootPath.length, path.length - 1);
        final ClientProjectFile dir = dirPath.length == 0 ? root : GetChildFromPathTask.runTask(root, dirPath);
        String msg = "[" + name + "]";
        ImageIcon icon = ApplicationImages.ICON_ANIMATEDENGINES_32;
        ApplicationTask<ClientProjectFile> tsk = new ApplicationTask<ClientProjectFile>((Application)this, msg){

            @Override
            public void performTask() throws Exception {
                ClientProjectFile newFile = project.createAndWaitForFile(dir, name, type);
                this.setResult(newFile);
            }
        };
        boolean ok = tsk.execute(this.getApplicationFrame(), "", msg, icon);
        if (!ok) {
            return null;
        }
        return (ClientProjectFile)tsk.getResult();
    }
}

