/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop.dircontents;

import csbase.client.desktop.RemoteTask;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import tecgraf.javautils.core.lng.LNG;

public class DirectoryContentsCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final Window ownerWindow;
    private final String ownerTitle;
    private ClientProjectFile file;
    private final JComponent component = new JTextField();

    @Override
    public Object getCellEditorValue() {
        final String nameTrimmed = ((JTextField)this.component).getText().trim();
        if (!ClientUtilities.isValidFileName(nameTrimmed)) {
            StandardErrorDialogs.showErrorDialog(this.ownerWindow, this.ownerTitle, LNG.get((String)"PRJ_PROJECT_FILE_NAME_CHARACTERES_ERROR"));
            return this.file;
        }
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                DirectoryContentsCellEditor.this.file.rename(nameTrimmed);
            }
        };
        task.execute(this.ownerWindow, this.ownerTitle, MessageFormat.format(LNG.get((String)"PRJ_WAITING_RENAME_FILE"), this.file.getName()));
        return this.file;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
        this.file = (ClientProjectFile)value;
        String text = this.file.getName();
        ((JTextField)this.component).setText(text);
        return this.component;
    }

    public DirectoryContentsCellEditor(Window ownerWindow, String ownerTitle) {
        this.ownerWindow = ownerWindow;
        this.ownerTitle = ownerTitle;
    }
}

