/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.ProjectFileNameAndTypeFilter;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectFileChooser;
import csbase.client.project.ProjectTreePath;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;
import csbase.logic.filters.ProjectFileCompositeOrFilter;
import csbase.logic.filters.ProjectFileDirectoryFilter;
import csbase.logic.filters.ProjectFileNotDirectoryFilter;
import csbase.logic.filters.ProjectFileTypeFilter;
import java.awt.Window;
import tecgraf.javautils.core.lng.LNG;

public class ProjectFileChooserOpen
extends ProjectFileChooser {
    public ProjectFileChooserOpen(Window owner, CommonClientProject project, boolean isMultiSelectionEnabled, int mode) throws ClientException {
        this(owner, project, isMultiSelectionEnabled, mode, null);
    }

    public ProjectFileChooserOpen(Window owner, CommonClientProject project, boolean isMultiSelectionEnabled, int mode, String fileType) throws ClientException {
        super(owner, LNG.get((String)"PRJ_FILE_CHOOSER_OPEN_TITLE"), project, isMultiSelectionEnabled, mode, fileType, ProjectFileChooserOpen.createVisualFilter(mode, fileType), ProjectFileChooserOpen.createSelectionFilter(mode, fileType), false, null, false);
        String title = this.getTitle();
        if (title != null) {
            this.dialog.setTitle(title);
        }
        this.dialog.setVisible(true);
    }

    public ProjectFileChooserOpen(Window owner, CommonClientProject project, boolean isMultiSelectionEnabled, int mode, String fileType, boolean useFilter) throws ClientException {
        super(owner, LNG.get((String)"PRJ_FILE_CHOOSER_OPEN_TITLE"), project, isMultiSelectionEnabled, mode, fileType, ProjectFileChooserOpen.createVisualFilter(mode, fileType), ProjectFileChooserOpen.createSelectionFilter(mode, fileType), false, null, useFilter);
        String title = this.getTitle();
        if (title != null) {
            this.dialog.setTitle(title);
        }
        this.dialog.setVisible(true);
    }

    public ProjectFileChooserOpen(Window owner, CommonClientProject project, boolean isMultiSelectionEnabled, String[] fileTypes, String defaultType) throws ClientException {
        super(owner, LNG.get((String)"PRJ_FILE_CHOOSER_OPEN_TITLE"), project, isMultiSelectionEnabled, 0, defaultType, ProjectFileChooserOpen.createVisualFilter(fileTypes), ProjectFileChooserOpen.createSelectionFilter(fileTypes), false, null, false);
        String title = this.getTitle();
        if (title != null) {
            this.dialog.setTitle(title);
        }
        this.dialog.setVisible(true);
    }

    private static ProjectFileFilter createSelectionFilter(String[] fileTypes) {
        ProjectFileCompositeOrFilter projectFileCompositeFilter = new ProjectFileCompositeOrFilter();
        projectFileCompositeFilter.addChild((ProjectFileFilter)new ProjectFileTypeFilter(fileTypes));
        return projectFileCompositeFilter;
    }

    private static ProjectFileFilter createVisualFilter(String[] fileTypes) {
        ProjectFileCompositeOrFilter projectFileCompositeFilter = new ProjectFileCompositeOrFilter();
        projectFileCompositeFilter.addChild((ProjectFileFilter)ProjectFileDirectoryFilter.getInstance());
        projectFileCompositeFilter.addChild((ProjectFileFilter)new ProjectFileTypeFilter(fileTypes));
        return projectFileCompositeFilter;
    }

    private static ProjectFileFilter createSelectionFilter(int mode, String fileType) {
        ProjectFileCompositeOrFilter projectFileCompositeFilter = new ProjectFileCompositeOrFilter();
        if (mode == 0 || mode == 2) {
            if (fileType == null) {
                projectFileCompositeFilter.addChild((ProjectFileFilter)ProjectFileNotDirectoryFilter.getInstance());
            } else {
                projectFileCompositeFilter.addChild((ProjectFileFilter)new ProjectFileTypeFilter(fileType));
            }
        }
        if (mode == 1 || mode == 2) {
            projectFileCompositeFilter.addChild((ProjectFileFilter)ProjectFileDirectoryFilter.getInstance());
        }
        return projectFileCompositeFilter;
    }

    private static ProjectFileFilter createVisualFilter(int mode, String fileType) {
        ProjectFileCompositeOrFilter projectFileCompositeFilter = new ProjectFileCompositeOrFilter();
        projectFileCompositeFilter.addChild((ProjectFileFilter)ProjectFileDirectoryFilter.getInstance());
        if (mode == 0 || mode == 2) {
            if (fileType == null) {
                projectFileCompositeFilter.addChild((ProjectFileFilter)ProjectFileNotDirectoryFilter.getInstance());
            } else {
                projectFileCompositeFilter.addChild((ProjectFileFilter)new ProjectFileTypeFilter(fileType));
            }
        }
        return projectFileCompositeFilter;
    }

    @Override
    protected ProjectFileFilter getVisualFilter() {
        return ProjectFileChooserOpen.createVisualFilter(this.mode, null);
    }

    @Override
    protected ProjectFileFilter getVisualFilter(String fileType) {
        return ProjectFileChooserOpen.createVisualFilter(this.mode, fileType);
    }

    @Override
    protected ProjectFileFilter getVisualFilter(String nameFilter, String fileType) {
        if (nameFilter == null || nameFilter.isEmpty()) {
            return ProjectFileChooserOpen.createVisualFilter(this.mode, fileType);
        }
        ProjectFileCompositeOrFilter projectFileCompositeFilter = new ProjectFileCompositeOrFilter();
        projectFileCompositeFilter.addChild((ProjectFileFilter)ProjectFileDirectoryFilter.getInstance());
        if (this.mode == 0 || this.mode == 2) {
            projectFileCompositeFilter.addChild((ProjectFileFilter)new ProjectFileNameAndTypeFilter(nameFilter, fileType));
        }
        return projectFileCompositeFilter;
    }

    @Override
    protected ProjectFileFilter getSelectionFilter() {
        return ProjectFileChooserOpen.createSelectionFilter(this.mode, null);
    }

    @Override
    protected ProjectFileFilter getSelectionFilter(String fileType) {
        return ProjectFileChooserOpen.createSelectionFilter(this.mode, fileType);
    }

    @Override
    protected ProjectFileFilter getSelectionFilter(String nameFilter, String fileType) {
        if (nameFilter == null || nameFilter.isEmpty()) {
            return ProjectFileChooserOpen.createSelectionFilter(this.mode, fileType);
        }
        ProjectFileCompositeOrFilter projectFileCompositeFilter = new ProjectFileCompositeOrFilter();
        projectFileCompositeFilter.addChild((ProjectFileFilter)ProjectFileDirectoryFilter.getInstance());
        if (this.mode == 0 || this.mode == 2) {
            projectFileCompositeFilter.addChild((ProjectFileFilter)new ProjectFileNameAndTypeFilter(nameFilter, fileType));
        }
        return projectFileCompositeFilter;
    }

    @Override
    protected boolean handleAction() {
        ClientProjectFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles != null) {
            this.selectedPaths = new ProjectTreePath[selectedFiles.length];
            for (int i = 0; i < this.selectedPaths.length; ++i) {
                this.selectedPaths[i] = new ProjectTreePath(selectedFiles[i]);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void makeSelection(ClientProjectFile[] projectFileArray) {
        if (projectFileArray.length == 0) {
            this.selectedPaths = null;
            this.fileNameText.setText("");
        } else {
            this.selectedPaths = new ProjectTreePath[projectFileArray.length];
            String newText = "";
            String separator = "";
            for (int i = 0; i < projectFileArray.length; ++i) {
                this.selectedPaths[i] = new ProjectTreePath(projectFileArray[i]);
                newText = newText + separator + projectFileArray[i].getName();
                separator = ",";
            }
            this.fileNameText.setText(newText);
        }
    }
}

