/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser;

import csbase.client.util.filechooser.ClientFileChooser;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.client.util.filechooser.filetablepanel.ClientFileTablePanel;
import csbase.client.util.filechooser.filetablepanel.ClientFileTableSelectionListener;
import csbase.logic.ClientFile;
import java.util.ArrayList;
import java.util.List;

class ClientFileChooserSelectionListener
implements ClientFileTableSelectionListener {
    private final ClientFileChooser chooser;

    @Override
    public void selectionPerformed(ClientFileTablePanel panel, List<ClientFile> selectionList) {
        ClientFileChooserType type = this.chooser.getSelectionType();
        switch (type) {
            case SAVE: {
                this.handleSaveType(selectionList);
                break;
            }
            case OPEN: {
                this.handleOpenType(selectionList);
            }
        }
    }

    private void handleSaveType(List<ClientFile> selectionList) {
        ClientFileChooserSelectionMode selectionMode = this.chooser.getSelectionMode();
        if (selectionList.size() == 0) {
            this.clearSelection();
            return;
        }
        ClientFile selection = selectionList.get(0);
        boolean flag = false;
        switch (selectionMode) {
            case DIRECTORIES_ONLY: {
                flag = selection.isDirectory();
                break;
            }
            case FILES_ONLY: {
                boolean bl = flag = !selection.isDirectory();
            }
        }
        if (flag) {
            ArrayList<ClientFile> uniq = new ArrayList<ClientFile>();
            uniq.add(selection);
            this.chooser.setChosenItens(uniq);
        } else {
            this.clearSelection();
        }
    }

    private void clearSelection() {
        ArrayList<ClientFile> empty = new ArrayList<ClientFile>();
        this.chooser.setChosenItens(empty);
    }

    private void handleOpenType(List<ClientFile> selectionList) {
        ArrayList<ClientFile> realList = new ArrayList<ClientFile>();
        ClientFileChooserSelectionMode selectionMode = this.chooser.getSelectionMode();
        for (ClientFile s : selectionList) {
            boolean isDir = s.isDirectory();
            if (isDir && selectionMode == ClientFileChooserSelectionMode.FILES_ONLY || !isDir && selectionMode == ClientFileChooserSelectionMode.DIRECTORIES_ONLY) continue;
            realList.add(s);
        }
        this.chooser.setChosenItens(realList);
    }

    ClientFileChooserSelectionListener(ClientFileChooser chooser) {
        this.chooser = chooser;
    }
}

