/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.configurabletable;

import csbase.client.facilities.configurabletable.column.IConfigurableColumn;
import csbase.client.facilities.configurabletable.model.Column;
import csbase.client.facilities.configurabletable.model.Columns;
import csbase.client.facilities.configurabletable.model.Config;
import csbase.client.facilities.configurabletable.model.Filter;
import csbase.client.facilities.configurabletable.model.Filters;
import csbase.client.facilities.configurabletable.model.Table;
import csbase.client.facilities.configurabletable.model.Tables;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import java.awt.Dimension;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SortOrder;
import tecgraf.javautils.core.filter.IFilter;

public class ConfigurableTableFactory {
    private Config tablesConfig;
    private IStringProvider stringProvider;
    private Map<String, Table> tablesById;
    private Map<String, Column> columnsById;
    private Map<String, Filter> filtersById;

    private ConfigurableTableFactory(IStringProvider stringProvider) {
        this.stringProvider = stringProvider;
        if (this.stringProvider == null) {
            this.stringProvider = new IStringProvider(){

                @Override
                public String getString(String key) {
                    return key;
                }
            };
        }
    }

    public ConfigurableTableFactory(Config config, IStringProvider stringProvider) {
        this(stringProvider);
        this.tablesConfig = config;
        this.buildMaps();
    }

    private void buildMaps() {
        this.tablesById = new HashMap<String, Table>();
        this.columnsById = new HashMap<String, Column>();
        this.filtersById = new HashMap<String, Filter>();
        if (this.tablesConfig != null) {
            Columns columns = this.tablesConfig.getColumns();
            for (Column column : columns.getColumn()) {
                this.columnsById.put(column.getId(), column);
            }
            Tables tables = this.tablesConfig.getTables();
            for (Table table : tables.getTable()) {
                this.tablesById.put(table.getId(), table);
            }
            Filters filters = this.tablesConfig.getFilters();
            for (Filter filter : filters.getFilter()) {
                this.filtersById.put(filter.getId(), filter);
            }
        }
    }

    public ConfigurableTable<?> getTable(String tableId) {
        Table tableConf = this.tablesById.get(tableId);
        if (tableConf != null) {
            Class<?> dataType;
            String className = tableConf.getDatatype();
            try {
                dataType = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Classe que representa os objetos da tabela n\u00e3o foi encontrada: " + className);
            }
            return this.getTable(tableId, dataType);
        }
        return null;
    }

    public <T> ConfigurableTable<T> getTable(String tableId, Class<T> dataType) {
        Table tableConf = this.tablesById.get(tableId);
        ConfigurableTable table = null;
        if (tableConf != null) {
            String[] sortElements;
            ArrayList columns = new ArrayList();
            for (Table.ColumnRef columnRef : tableConf.getColumnRef()) {
                Column columnConf = this.columnsById.get(columnRef.getId());
                columns.add(this.createColumn(dataType, columnConf, columnRef.isVisible()));
            }
            table = new ConfigurableTable(tableId, columns, null);
            if (tableConf.getFilter() != null) {
                String filterId = tableConf.getFilter();
                Filter filterConf = this.filtersById.get(filterId);
                IFilter<T> filter = this.createFilter(dataType, filterConf);
                table.setFilter(filter);
            }
            if (tableConf.getOrderby() != null && (sortElements = tableConf.getOrderby().split("\\|")).length == 2) {
                int columnIndex = 0;
                for (int i = 0; i < tableConf.getColumnRef().size(); ++i) {
                    Table.ColumnRef columnRef = tableConf.getColumnRef().get(i);
                    if (!columnRef.getId().equals(sortElements[0])) continue;
                    columnIndex = i;
                    break;
                }
                if ("desc".equals(sortElements[1])) {
                    table.sort(columnIndex, SortOrder.DESCENDING);
                } else {
                    table.sort(columnIndex, SortOrder.ASCENDING);
                }
            }
            int height = tableConf.getHeight() != null ? tableConf.getHeight() : 300;
            int width = tableConf.getWidth() != null ? tableConf.getWidth() : 500;
            table.setPreferredSize(new Dimension(width, height));
        }
        return table;
    }

    public boolean hasTable(String tableId) {
        return this.tablesById.get(tableId) != null;
    }

    private <T> IFilter<T> createFilter(Class<T> dataType, Filter filterConf) {
        IFilter filter = null;
        try {
            Class<?> clazz = Class.forName(filterConf.getClazz());
            if (filterConf.getParam().size() > 0) {
                Constructor<?> construtor = clazz.getConstructor(Map.class);
                HashMap<String, String> params = new HashMap<String, String>();
                for (Filter.Param param : filterConf.getParam()) {
                    params.put(param.getName(), param.getValue());
                }
                filter = (IFilter)construtor.newInstance(params);
            } else {
                Constructor<?> construtor = clazz.getConstructor(new Class[0]);
                filter = (IFilter)construtor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Erro ao construir filtro com id:" + filterConf.getId(), e);
        }
        return filter;
    }

    private <T> IConfigurableColumn<T> createColumn(Class<T> dataType, Column columnConf, boolean visibility) {
        IConfigurableColumn column = null;
        try {
            Class<?> clazz = Class.forName(columnConf.getClazz());
            Constructor<?> construtor = clazz.getConstructor(String.class, Boolean.class, IStringProvider.class, Integer.class);
            int align = this.convertColumnAlign(columnConf.getAlign());
            column = (IConfigurableColumn)construtor.newInstance(columnConf.getId(), visibility, this.stringProvider, align);
        }
        catch (Exception e) {
            throw new RuntimeException("Erro ao construir coluna com id:" + columnConf.getId(), e);
        }
        return column;
    }

    private int convertColumnAlign(String align) {
        if ("left".equals(align)) {
            return 2;
        }
        if ("right".equals(align)) {
            return 4;
        }
        return 0;
    }
}

