package csbase.client.applications.algorithmsmanager.report.implementations;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.algorithmsmanager.report.core.AbstractRemoteTest;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;

/**
 * Teste para saber se existem algoritmos sem configurador
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class TestConfiguratorInvalid extends AbstractRemoteTest<AlgorithmInfo> {

  /**
   * Construtor
   * 
   * @param taskWindow Window para a task
   */
  public TestConfiguratorInvalid(Window taskWindow) {
    super(taskWindow, LNG.get("TestConfiguratorInvalid.task.title"), LNG
      .get("TestConfiguratorInvalid.task.message"));

  }

  /** {@inheritDoc} */
  @Override
  public List<IResultMessage<AlgorithmInfo>> doTest(AlgorithmInfo algorithmInfo) {

    List<IResultMessage<AlgorithmInfo>> list = new ArrayList<>();

    for (AlgorithmVersionInfo version : algorithmInfo.getVersions()) {
      if (version != null) {
        try {
          ClientRemoteLocator.algorithmService.createAlgorithmConfigurator(
            algorithmInfo.getName(), version.getId());

          IResultMessage<AlgorithmInfo> message =
            new ResultMessage<>(algorithmInfo, TestStatus.OK, LNG.get(
              "TestConfiguratorInvalid.valid", new String[] { version
                .toString() }));
          list.add(message);
        }
        catch (AlgorithmNotFoundException notFound) {
          IResultMessage<AlgorithmInfo> message =
            new ResultMessage<>(algorithmInfo, TestStatus.ERROR, LNG.get(
              "TestConfiguratorInvalid.invalid", new String[] { version
                .toString() }));
          list.add(message);
        }
        catch (Exception e) {
          IResultMessage<AlgorithmInfo> message =
            new ResultMessage<>(algorithmInfo, TestStatus.ERROR, LNG.get(
              "TestConfiguratorInvalid.exception", new String[] {
                  version.toString(), e.getMessage() }));
          list.add(message);
        }
      }
    }

    return list;
  }

  /** {@inheritDoc} */
  @Override
  public String getName() {
    return LNG.get("TestConfiguratorInvalid.name");
  }

  /** {@inheritDoc} */
  @Override
  public String getDescription() {
    return LNG.get("TestConfiguratorInvalid.description");
  }

  /** {@inheritDoc} */
  @Override
  public Class<AlgorithmInfo> getSubjectClass() {
    return AlgorithmInfo.class;
  }

  /** {@inheritDoc} */
  @Override
  public String getSubjectName(AlgorithmInfo subject) {
    return subject.getName();
  }
}
