package csbase.client.openbus;

/**
 * Interface interna de recebimento de eventos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface OpenBusEventReceiverInterface {

  /**
   * Recebe mensagem sem valor
   * 
   * @param sourceId id do remetente
   * @param destId id do destinatrio
   * @param type tipo
   * @return indicativo de tratamento do evento.
   */
  public boolean receiveEventWithNoValue(String sourceId, String destId,
    String type);

  /**
   * Recebe mensagem com valor string.
   * 
   * @param sourceId id do remetente
   * @param destId id do destinatrio
   * @param type tipo
   * @param stringValue valor string
   * @return indicativo de tratamento do evento.
   */
  public boolean receiveEventWithStringValue(String sourceId, String destId,
    String type, String stringValue);

  /**
   * Recebe mensagem com valor booleano.
   * 
   * @param sourceId id do remetente
   * @param destId id do destinatrio
   * @param type tipo
   * @param booleanValue valor booleano.
   * @return indicativo de tratamento do evento.
   */
  public boolean receiveEventWithBooleanValue(String sourceId, String destId,
    String type, boolean booleanValue);

  /**
   * Mtodo redefinvel para gerar log do tratador.
   * 
   * @param treated indicativo de tratamento
   * @param sourceId id da fonte.
   * @param destId id do destino.
   * @param type tipo
   * @param value valor
   */
  public void logReceivedEvent(boolean treated, String sourceId, String destId,
    String type, Object value);
}
