package csbase.client.applications.jobmonitor.columns;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;

/**
 * Coluna que exibe valores do tipo Double e que possuem ordem de grandeza.
 * 
 * @author Tecgraf
 */
public class DoubleWithMagnitudeJobInfoColumn extends
  AbstractConfigurableColumn<JobInfoRow> {

  /**
   * Ordem de grandeza do valor.
   */
  private String magnitude;

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param magnitude - ordem de grandeza do valor.
   */
  public DoubleWithMagnitudeJobInfoColumn(String id, String magnitude) {
    super(id, true, null, null);
    this.magnitude = magnitude;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return Double.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getId();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(JobInfoRow obj) {
    String entireValue = obj.get(getId());

    Double result = null;
    if (entireValue != null) {
      String valueAsStr =
        entireValue.substring(0, entireValue.lastIndexOf(magnitude));

      result = Double.parseDouble(valueAsStr);
    }

    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {

    return new DefaultTableCellRenderer() {
      @Override
      public Component getTableCellRendererComponent(JTable table,
        Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
          row, column);

        if (value != null) {
          setText(value + " " + magnitude);
        }

        return this;
      }
    };

  }

}
