/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.dal.xml.elements;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLElement;
import tecgraf.javautils.xml.XMLElementInterface;
import csbase.client.applications.commandsmonitor.models.CommandsFilterDTO;

/**
 * Elemento conjunto de filtros.
 * 
 * @author Tecgraf
 */
public class FiltersSetElement extends XMLElement {

  /**
   * Consulta o nome da tag
   * 
   * @return tag
   */
  public static final String getTagName() {
    return "filters";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void endTag(List<XMLElementInterface> childrenList) {

    Set<CommandsFilterDTO> filtersInfo = new HashSet<CommandsFilterDTO>();

    ImprovedXMLListIterator iterator =
      new ImprovedXMLListIterator(childrenList);
    while (iterator.hasNext()) {
      XMLElementInterface aFilterElement = iterator.next();
      CommandsFilterDTO aFilterInfo =
        (CommandsFilterDTO) aFilterElement.getAppObject();
      filtersInfo.add(aFilterInfo);
    }

    setAppObject(filtersInfo);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(Writer writer, String ident) throws IOException {
    throw new IllegalAccessError("Esse mtodo no deve ser utilizado.");
  }
}