/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table.column;

import java.util.Locale;

import javax.swing.table.TableCellRenderer;

import csbase.client.facilities.commandtable.CommandStatusCellData;
import csbase.client.facilities.commandtable.CommandStatusCellRenderer;
import csbase.client.facilities.commandtable.CommandStatusHelper;
import csbase.logic.CommandInfo;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Coluna contendo uma representao grfica do estado do comando.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class StatusColumn extends AbstractCommandsTableColumn {

  /**
   * Renderiza a coluna de status utilizando cones para indicar o status do
   * comando.
   */
  private TableCellRenderer CELL_RENDERER = new CommandStatusCellRenderer();

  /**
   * Construtor.
   * 
   * @param id Identificador da coluna.
   * @param appRegistry registro da aplicao que ser utilizado para se obter o
   *        nome da coluna de acordo com o {@link Locale}.
   */
  public StatusColumn(String id, ApplicationRegistry appRegistry) {
    super(CommandStatusCellData.class, id, appRegistry);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(CommandInfo cmd) {
    return CommandStatusHelper.createCellData(cmd);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return CELL_RENDERER;
  }
}
