/*
 * $Id$
 */

package csbase.client.applications.filetransferclient.actions;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.remotepanel.FileTransferClientRemotePanel;

/**
 * @author admin
 * 
 */
public class RefreshRemoteAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(final JComponent component) {
    final FileTransferClient app = getApplication();
    final FileTransferClientRemotePanel remotePanel = app.getRemotePanel();
    remotePanel.refresh();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return ApplicationImages.ICON_REFRESH_16;
  }

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public RefreshRemoteAction(final FileTransferClient application) {
    super(application);
  }
}
