package csbase.client.applications.flowapplication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import tecgraf.javautils.gui.tree.DefaultNode;

/**
 * N Algoritmo.
 *
 * @author lmoreira
 */
public final class AlgorithmTreeNode extends DefaultNode implements
  Comparable<AlgorithmTreeNode> {
  /**
   * O algoritmo.
   */
  private final AlgorithmInfo algorithm;

  /**
   * cone do n.
   */
  private final ImageIcon icon;

  /**
   * Cria o n.
   *
   * @param algorithm O algoritmo (No aceita {@code null}).
   * @param showVersions Indica se devem ser mostradas as verses do algoritmo
   *        na rvore.
   */
  public AlgorithmTreeNode(final AlgorithmInfo algorithm,
    boolean showVersions) {
    super(algorithm.getName());
    this.algorithm = algorithm;
    this.icon = AlgorithmVersionTreeNode.getIconForVersion(algorithm
      .getLastVersion());
    if (showVersions) {
      final List<AlgorithmVersionTreeNode> children =
        new ArrayList<AlgorithmVersionTreeNode>();
      for (final AlgorithmVersionInfo algorithmVersion : algorithm
        .getVersions()) {
        children.add(new AlgorithmVersionTreeNode(algorithmVersion));
      }
      Collections.sort(children);
      for (final DefaultNode child : children) {
        addChild(child);
      }
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int compareTo(final AlgorithmTreeNode node) {
    return getAlgorithm().compareTo(node.getAlgorithm());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    final AlgorithmTreeNode other = (AlgorithmTreeNode) obj;
    return getAlgorithm().equals(other.getAlgorithm());
  }

  /**
   * Obtm o algoritmo.
   *
   * @return info do algoritmo.
   */
  public AlgorithmInfo getAlgorithm() {
    return this.algorithm;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Icon getIcon() {
    return icon;
  }
}
