/*
 * $Id: TreeUtil.java 173413 2016-05-10 19:56:56Z isabella $
 */
package csbase.client.applications.flowapplication;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import tecgraf.javautils.gui.tree.Node;

/**
 * Rotina utilitrias para uso com <code>JTree</code>
 * 
 * @author Tecgraf/PUC-Rio
 * @see JTree
 */
public class TreeUtil {

  /**
   * Consulta um path associado a um objeto
   * 
   * @param tree rvore
   * @param parentPath path do pai
   * @param node n
   * @param object objeto.
   * @return o path
   */
  private static TreePath hasObject(final JTree tree, final TreePath parentPath,
    final Node node, final Object object) {

    if (node.equals(object) && node.getParent().equals(((Node) object)
      .getParent())) {
      return parentPath.pathByAddingChild(node);
    }

    final TreePath path = parentPath.pathByAddingChild(node);
    for (Node childNode : node.getChildren()) {
      final TreePath tpath = TreeUtil.hasObject(tree, path, childNode, object);
      if (tpath != null) {
        return tpath;
      }
    }
    return null;
  }

  /**
   * Consulta um path associado a um objeto
   * 
   * @param tree rvore
   * @param object objeto.
   * @return o path (se existir)
   */
  private static TreePath hasRootObject(final JTree tree, final Object object) {
    final TreeModel model = tree.getModel();
    final Node root = (Node) model.getRoot();
    final TreePath rootPath = new TreePath(root);

    for (Node node : root.getChildren()) {
      final TreePath tpath = TreeUtil.hasObject(tree, rootPath, node, object);
      if (tpath != null) {
        return tpath;
      }
    }
    return null;
  }

  /**
   * Faz a carga de ns expandidos
   * 
   * @param tree rvore
   * @param vector lista de objetos associados.
   */
  public static void load(final JTree tree, final List<Object> vector) {
    for (final Object object : vector) {
      final TreePath path = TreeUtil.hasRootObject(tree, object);
      if (path != null) {
        tree.collapsePath(path);
      }
    }
  }

  /**
   * Aplica callback a todos os ns de rvore.
   * 
   * @param tree rvore
   * @param callback callback
   */
  static public void processNodes(final JTree tree,
    final NodeCallback callback) {
    final Node root = (Node) tree.getModel().getRoot();
    final TreePath rootPath = new TreePath(root);
    callback.preProcess(tree, null, root);
    if (root.getChildren().size() >= 0) {
      for (Node e : root.getChildren()) {
        final Node node = e;
        TreeUtil.visitNodes(tree, rootPath, node, callback);
      }
    }
    callback.postProcess(tree, null, root);
  }

  /**
   * <b>Ateno:</b> Funciona apenas com rvore cujos ns sejam do tipo
   * <code>DefaultMutableTreeNode</code>
   * 
   * @param tree a rvore
   * @return a lista
   */
  public static List<Object> save(final JTree tree) {
    final List<Object> vector = new ArrayList<>();
    final NodeCallback callback = new NodeCallback() {
      @Override
      final public void postProcess(final JTree t, final TreePath parentPath,
        final Node node) {
        final TreePath path;
        if (parentPath == null) {
          path = new TreePath(node);
        }
        else {
          path = parentPath.pathByAddingChild(node);
        }
        if (!t.isExpanded(path)) {
          vector.add(node);
        }
      }
    };
    TreeUtil.processNodes(tree, callback);
    return vector;
  }

  /**
   * Faz visita recursiva aos ns de rvore
   * 
   * @param tree rvore
   * @param parentPath path do pai
   * @param node n
   * @param callback callback a ser aplicada aos ns.
   */
  static private void visitNodes(final JTree tree, final TreePath parentPath,
    final Node node, final NodeCallback callback) {
    callback.preProcess(tree, parentPath, node);
    final TreePath path = parentPath.pathByAddingChild(node);
    if (node.getChildren().size() >= 0) {
      for (Node e : node.getChildren()) {
        final Node childNode = e;
        TreeUtil.visitNodes(tree, path, childNode, callback);
      }
    }
    callback.postProcess(tree, parentPath, node);
  }

}
