package csbase.client.applications.flowapplication.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;

/**
 * Ao de remover elementos do grafo no editor de fluxos.
 */
public final class RemoveElementsAction extends FlowApplicationAction {
  /**
   * Cria a ao.
   * 
   * @param application A aplicao.
   */
  public RemoveElementsAction(FlowApplication application) {
    super(application, ApplicationImages.ICON_DELETE_16);
    KeyStroke keyStroke = KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0);
    putValue(Action.ACCELERATOR_KEY, keyStroke);
    setEnabled(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleActionPerformed(ActionEvent e) {
    getApplication().removeSelectedElements();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementCreated(Graph graph, GraphElement element) {
    setEnabled(graph.hasSelectedElements());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementRemoved(Graph graph, GraphElement element) {
    setEnabled(graph.hasSelectedElements());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementSelected(Graph graph, GraphElement element) {
    setEnabled(graph.hasSelectedElements());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasChangedWorkspace(Graph graph) {
    setEnabled(graph.hasSelectedElements());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasReseted(Graph graph) {
    setEnabled(false);
  }
}
