/*
 * $Id$
 */
package csbase.client.project.action;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;

import javax.swing.JOptionPane;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectFileContainer;
import csbase.client.util.ClientUtilities;
import csbase.logic.ClientProjectFile;

/**
 * Ao para renomear arquivos da rvore de projetos.
 */
public class CommonFileRenameAction extends CommonProjectAction {

  /**
   * Construtor.
   * 
   * @param container o container.
   */
  public CommonFileRenameAction(ProjectFileContainer container) {
    super(container);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    startRenamingAction();
    clearClipboard();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return LNG.get("PRJ_RENAME");
  }

  /**
   * Solicita ao servidor para renomear o arquivo ou diretrio.
   * 
   * @param file O arquivo ou diretrio a ser renomeado.
   * @param name O novo nome.
   */
  public void rename(final ClientProjectFile file, String name) {
    if (file.getParent() == null) {
      return; //raiz no pode ser renomeada
    }
    final Window owner = getWindow();
    final String ownerTitle = getTitle();
    final String nameTrimmed = name.trim();
    if (!ClientUtilities.isValidFileName(nameTrimmed)) {
      showError(owner, ownerTitle,
        LNG.get("PRJ_PROJECT_FILE_NAME_CHARACTERES_ERROR"));
      return;
    }
    if (nameTrimmed.startsWith(".") && !file.getName().startsWith(".")) {
      int answer =
        StandardDialogs.showYesNoDialog(owner, ownerTitle,
          LNG.get("PRJ_PROJECT_FILE_UPLOAD_TO_HIDDEN_CONFIRMATION"));
      if (answer != JOptionPane.YES_OPTION) {
        return;
      }
    }
    /* Define os textos de mensagens */
    final String fileType =
      file.isDirectory() ? LNG.get("PRJ_DIRECTORY") : LNG.get("PRJ_FILE");

    /* Define e cria a RemoteTask */
    RemoteTask<Void> task = new RemoteTask<Void>() {

      @Override
      protected void performTask() throws Exception {
        file.rename(nameTrimmed);
      }
    };

    /*
     * Executa a tarefa. Os erros so tratados diretamente por ela.
     */
    task.execute(owner, ownerTitle, MessageFormat.format(
      LNG.get("PRJ_WAITING_RENAME_FILE"), new Object[] { fileType }));
  }
}
