/*
 * $Id$
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.project.ProjectFileContainer;

/**
 * Ao que abre dilogo para "alterao de tipo" de arquivo da rvore de
 * projetos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CommonFileTypeChangeAction extends CommonProjectAction {

  /**
   * Construtor.
   * 
   * @param container container
   */
  public CommonFileTypeChangeAction(ProjectFileContainer container) {
    super(container);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    FileTypeChangeDialog
      .show(getWindow(), this.getProject(), getSelectedFile());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return LNG.get("PRJ_CHANGE_TYPE");
  }

}
