/*
 * $Id$
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTree;

/**
 * Ao que atualiza a rvore de projeto.
 */
public class ProjectTreeUpdateAction extends ProjectAction {
  /**
   * Intervalo mnimo
   */
  private static final int MIN_REFRESH_INTERVAL = 500;

  /**
   * Tempo do ltimo update.
   */
  private long lastUpdateAction = -1;

  /**
   * Executa a ao.
   * 
   * @param e .
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    if (lastUpdateAction != -1) {
      long intervalAfterLastUpdate =
        System.currentTimeMillis() - lastUpdateAction;
      if (intervalAfterLastUpdate < MIN_REFRESH_INTERVAL) {
        return;
      }
    }
    RemoteTask<Void> task = new RemoteTask<Void>() {
      @Override
      public void performTask() throws Exception {
        getCurrentProject().refreshTree();
      }
    };

    task.execute(getWindow(), getTitle(), LNG.get("PRJ_WAITING_REFRESH_TREE"));
  }

  /**
   * Obtm o nome da ao.
   * 
   * @return .
   */
  @Override
  public String getName() {
    return LNG.get("PRJ_UPDATE_TREE");
  }

  /**
   * Constri a ao.
   * 
   * @param treeView .
   */
  public ProjectTreeUpdateAction(ProjectTree treeView) {
    super(treeView);
  }
}
