package csbase.client.util.table;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * Clula de <i>Checkbox</i>: uma clula que exibe uma {@link JCheckBox}.
 */
public final class CheckBoxCellView extends AbstractCellView {

  /**
   * A checkbox.
   */
  private JCheckBox checkBox;

  /**
   * Cria uma clula
   */
  public CheckBoxCellView() {
    checkBox = new JCheckBox();
    checkBox.setHorizontalAlignment(SwingConstants.CENTER);
    checkBox.addChangeListener(new ChangeListener() {
    
      public void stateChanged(ChangeEvent e) {
        fireValueWasChanged();
      }
    
    });
  }

  public Object getValue() {
    return checkBox.isSelected();
  }

  public JComponent getView() {
    return checkBox;
  }

  @Override
  protected void keepValue(Object value) {
    Boolean booleanValue = (Boolean) value;
    checkBox.setSelected(booleanValue);
  }
}
