/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.ProjectCommentsDialog;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.logic.ProjectPermissions;
import csbase.logic.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;

public class OpenProjectCommentsDialogAction
extends ProjectsManagerAction {
    public OpenProjectCommentsDialogAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() == 0) {
            return;
        }
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        ProjectCommentsDialog phd = new ProjectCommentsDialog(projectsManager, projects);
        phd.pack();
        phd.setVisible(true);
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ApplicationImages.ICON_HISTORY_16;
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        String someDeniedMessage;
        int res;
        ArrayList<ProjectsManagerData> prjList = new ArrayList<ProjectsManagerData>();
        prjList.addAll(projectList);
        ArrayList<ProjectsManagerData> failedProjects = new ArrayList<ProjectsManagerData>();
        User loggedUser = User.getLoggedUser();
        Object loggedUserId = loggedUser.getId();
        int i = 0;
        while (i < prjList.size()) {
            boolean hasWriteAccess;
            ProjectsManagerData pmd = (ProjectsManagerData)prjList.get(i);
            ProjectSpaceAllocation spaceAllocation = pmd.getProjectSpaceAllocation();
            ProjectPermissions.SharingType sharingType = pmd.getSharingType();
            Set<Object> usersRW = pmd.getUsersRW();
            boolean isAdmin = loggedUser.isAdmin();
            boolean isOwner = pmd.getOwnerId().equals(loggedUserId);
            boolean bl = hasWriteAccess = sharingType == ProjectPermissions.SharingType.ALL_RW || sharingType == ProjectPermissions.SharingType.PARTIAL && usersRW.contains(loggedUserId);
            if (spaceAllocation.isOpenable() && (isAdmin || isOwner || hasWriteAccess)) {
                ++i;
                continue;
            }
            failedProjects.add(pmd);
            prjList.remove(i);
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        if (prjList.size() == 0) {
            String deniedMessage = this.getString("OpenProjectCommentsDialogAction.project.selection.denied.message") + this.getString("OpenProjectCommentsDialogAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(projectsManager, deniedMessage, failedProjects, this.getString("OpenProjectCommentsDialogAction.project.selection.failure.message"));
            return null;
        }
        if (failedProjects.size() > 0 && (res = StatusDialog.showSomeOkDialog(projectsManager, someDeniedMessage = this.getString("OpenProjectCommentsDialogAction.project.selection.some.denied.message") + this.getString("OpenProjectCommentsDialogAction.project.requirements.message"), prjList, this.getString("OpenProjectCommentsDialogAction.project.selection.some.failure.message"))) == 0) {
            return null;
        }
        return prjList;
    }
}

