/*
 * $Id$
 */
package csbase.client;

import java.awt.event.InputEvent;

import javax.swing.KeyStroke;

/**
 * Tradutor de teclas.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ClientKeyStrokeUtil {

  /**
   * Pega uma tecla com base no texto (primeiro caracter)
   * 
   * @param text o texto
   * @return a tecla
   */
  static public int getKey(final String text) {
    if (text == null || text.trim().isEmpty()) {
      throw new IllegalArgumentException("Null or empty text detected!");
    }
    final KeyStroke k = KeyStroke.getKeyStroke(text);
    if (k != null) {
      return k.getKeyCode();
    }
    throw new IllegalArgumentException("Unhandled text detected!");
  }

  /**
   * Retorna o key-stroke com ctrl.
   * 
   * @param text o texto
   * @return o stroke
   */
  static public KeyStroke getCtrlAltKeyStroke(final String text) {
    final int k = getKey(text);
    final int mask = InputEvent.ALT_DOWN_MASK | InputEvent.CTRL_DOWN_MASK;
    return KeyStroke.getKeyStroke(k, mask);
  }

  /**
   * Retorna o key-stroke com ctrl.
   * 
   * @param text o texto
   * @return o stroke
   */
  static public KeyStroke getCtrlKeyStroke(final String text) {
    final int k = getKey(text);
    final int mask = InputEvent.CTRL_DOWN_MASK;
    return KeyStroke.getKeyStroke(k, mask);
  }

  /**
   * Retorna o key-stroke com alt.
   * 
   * @param text o texto
   * @return o stroke
   */
  static public KeyStroke getAltKeyStroke(final String text) {
    final int k = getKey(text);
    final int mask = InputEvent.ALT_DOWN_MASK;
    return KeyStroke.getKeyStroke(k, mask);
  }
}
