package csbase.client.algorithms.parameters;

import java.util.ArrayList;
import java.util.List;

import csbase.client.util.table.CellViewFactory;
import csbase.client.util.table.ComboBoxCellViewFactory;
import csbase.client.util.table.ComboBoxCellViewItem;
import csbase.logic.algorithms.parameters.EnumerationColumn;
import csbase.logic.algorithms.parameters.EnumerationItem;

/**
 * Viso para {@link EnumerationColumn}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class EnumerationColumnView extends
  AbstractTableColumnView<EnumerationItem, EnumerationColumn> {

  /**
   * Cria a viso de colunas.
   *
   * @param tableView A viso da tabela (No aceita {@code null}).
   * @param column A coluna (No aceita {@code null}).
   */
  public EnumerationColumnView(TableParameterView tableView,
    EnumerationColumn column) {
    super(tableView, column);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public CellViewFactory getFactory() {
    List<EnumerationItem> items = getColumn().getItems();
    List<ComboBoxCellViewItem> cellViewItems =
      new ArrayList<ComboBoxCellViewItem>(items.size());
    for (EnumerationItem item : items) {
      ComboBoxCellViewItem cellViewItem = new ComboBoxCellViewItem(item
        .getLabel(), item.getDescription(), item);
      cellViewItems.add(cellViewItem);
    }
    return new ComboBoxCellViewFactory().withItems(cellViewItems);
  }
}
