package csbase.client.applications.algorithmsmanager.dialogs;

import javax.swing.JPanel;

import csbase.client.applications.algorithmsmanager.actions.CategoryManagementAction;
import csbase.client.applications.algorithmsmanager.actions.CommonManagementAction;
import csbase.client.applications.algorithmsmanager.models.CategoryNodeInterface;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.CategorySet;

/**
 * Essa classe representa um painel para alterao de uma categoria.
 * 
 * A categoria selecionada  inicialmente exibida para consulta e pode ser
 * habilitada para alterao dos dados, atravs de uma ao de Editar. Toda
 * alterao  enviada para o servidor para atualizao.
 * 
 */
public class CategoryEditDataPanel extends CommonEditTabbedPanel {
  /** Painel com as informaes bsicas da categoria */
  private CategoryBasicInfoPanel infoPanel;

  /**
   * Categoria selecionado para alterao
   */
  private CategoryNodeInterface selectedCategory;

  /**
   * Constri o painel para alterao de uma categoria selecionada
   * 
   * @param action ao que criou esse painel
   */
  public CategoryEditDataPanel(CommonManagementAction action) {
    super(action);
  }

  /**
   * Obtm a ao de criar categoria que criou esse painel.
   * 
   * @return a ao de criar categoria
   */
  public CategoryManagementAction getCategoryManagementAction() {
    return (CategoryManagementAction) getAction();
  }

  @Override
  public boolean confirmDataChanged() {
    if (infoPanel.wasModified()) {
      // Confirma o cancelamento das abas alteradas
      return confirmCancelling();
    }
    return true;
  }

  /**
   * Atribui uma nova categoria para edio.
   * 
   * @param categoryNode n selecionado
   * 
   */
  public void changeUpdateInfo(CategoryNodeInterface categoryNode) {
    selectedCategory = categoryNode;
    initializeData();
  }

  /**
   * Obtm a categoria selecionada para edio.
   * 
   * @return a categoria selecionada para edio
   */
  public CategoryNodeInterface getSelectedCategory() {
    return selectedCategory;
  }

  @Override
  protected void buildAdditionalInfoPanel() {
  }

  @Override
  protected JPanel buildBasicInfoPanel() {
    infoPanel = new CategoryBasicInfoPanel(this);
    return infoPanel;
  }

  @Override
  public void initializeData() {
    infoPanel.initializeData();
  }

  @Override
  protected void handleCategoryUpdated(CategorySet modifiedCategorySet) {
    initializeData();
  }

  @Override
  protected void handleAlgorithmCreated(AlgorithmInfo algoInfo) {
    initializeData();
  }

  @Override
  protected void handleAlgorithmRemoved(AlgorithmInfo algoInfo) {
    initializeData();
  }

  @Override
  protected void handleAlgorithmUpdated(AlgorithmInfo algoInfo) {
    initializeData();
  }
}
