/*
 * $Id$
 */

package csbase.client.applications.desktoplauncher.actions;

import java.awt.event.ActionEvent;

import csbase.client.applications.desktoplauncher.DesktopLauncher;
import csbase.client.applications.desktoplauncher.DesktopLauncherEventHandler;

/**
 * Ao para matar o desktop-filho.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DesktopShutdownAction extends DesktopLauncherAction {

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public DesktopShutdownAction(DesktopLauncher application) {
    super(application);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) {
    final DesktopLauncherEventHandler eventHandler = getEventHandler();
    if (eventHandler == null) {
      return;
    }
    final DesktopLauncher application = getApplication();
    final String sonId = application.getSonId();
    final boolean treated = eventHandler.fireDesktopShutdownEvent(sonId);
    if (!treated) {
      final String err =
        getString("DesktopShutdownAction.event.not.sent.error");
      application.showError(err);
    }
  }
}
