package csbase.client.applications.flowapplication;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.logic.algorithms.AlgorithmConfigurator.ConfiguratorType;
import tecgraf.javautils.gui.tree.DefaultNode;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * N Verso do Algoritmo.
 *
 * @author lmoreira
 */
public class AlgorithmVersionTreeNode extends DefaultNode implements
  Comparable<AlgorithmVersionTreeNode> {
  /**
   * A verso do algoritmo.
   */
  private final AlgorithmVersionInfo algorithmVersion;

  /**
   * cone do n.
   */
  private final ImageIcon icon;

  /**
   * Cria o n.
   *
   * @param algorithmVersionInfo A verso do algoritmo (No aceita {@code null}
   *        ).
   */
  public AlgorithmVersionTreeNode(
    final AlgorithmVersionInfo algorithmVersionInfo) {
    super(algorithmVersionInfo.getId().toString(), FiltrageMode.IGNORE);
    this.algorithmVersion = algorithmVersionInfo;
    this.icon = getIconForVersion(algorithmVersionInfo);
  }

  /**
   * Obtm o cone para a verso especificada.
   *
   * @param algorithmVersion a verso do algoritmo.
   * @return o cone que representa a verso especificada.
   */
  static ImageIcon getIconForVersion(AlgorithmVersionInfo algorithmVersion) {
    if (algorithmVersion != null) {
      ConfiguratorType type = algorithmVersion.getType();
      if (type == ConfiguratorType.SIMPLE) {
        return ApplicationImages.ICON_FLOW_NODE_16;
      }
      if (type == ConfiguratorType.FLOW) {
        return ApplicationImages.ICON_FLOW_16;
      }
    }
    return ApplicationImages.ICON_BLANK_16;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int compareTo(final AlgorithmVersionTreeNode node) {
    return getAlgorithmVersion().compareTo(node.getAlgorithmVersion());
  }

  /**
   * Obtm a verso do algoritmo.
   *
   * @return A verso do algoritmo.
   */
  public AlgorithmVersionInfo getAlgorithmVersion() {
    return this.algorithmVersion;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Icon getIcon() {
    return icon;
  }
}
