package csbase.client.applications.flowapplication.graph.actions;

import java.awt.event.ActionEvent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddGraphPopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.messages.RemoveElementsMessage;

/**
 * Ao de menu popup que remove elementos que esto selecionados em um fluxo de
 * algoritmos.
 * 
 * @author lmoreira
 */
public final class RemoveSelectedElementsAction extends GraphAction {
  /**
   * Cria a ao.
   * 
   * @param graph O fluxo (No aceita {@code null}).
   */
  public RemoveSelectedElementsAction(final Graph graph) {
    super(graph, RemoveSelectedElementsAction.class.getName() + ".name",
      ApplicationImages.ICON_DELETE_16);
    setEnabled(graph.hasSelectedElements());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(final ActionEvent e) {
    new RemoveElementsMessage().sendVO(getGraph());
  }

  /**
   * Cria o filtro que cadastra a ao no menu popup.
   * 
   * @param workspace A rea de trabalho (No aceita {@code null}).
   * 
   * @return O filtro.
   */
  public static WorkspaceFilter createFilter(final Workspace workspace) {
    if (workspace == null) {
      throw new IllegalArgumentException("O parmetro workspace est nulo.");
    }
    return new AddGraphPopupActionFilter(workspace) {

      @Override
      protected GraphAction createAction(final Graph graph) {
        return new RemoveSelectedElementsAction(graph);
      }
    };
  }
}
