/*
 * $Id$
 */

package csbase.client.desktop;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.WindowConstants;

import tecgraf.javautils.gui.GUIUtils;

/**
 * Dilogo de componente de desktop.
 *
 * @author Tecgraf/PUC-Rio
 */
public class DesktopComponentDialog extends JDialog implements
DesktopWindowInterface {

  /**
   * Ajusta a tecla esc para fechar o dilogo.
   */
  private void addEscListener() {
    final AbstractAction cancelAction = new AbstractAction() {
      @Override
      public void actionPerformed(final ActionEvent e) {
        DesktopComponentDialog.this.close();
      }
    };

    final int mode = JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT;
    final InputMap inputMap = rootPane.getInputMap(mode);
    final ActionMap actionMap = rootPane.getActionMap();
    final int esc = KeyEvent.VK_ESCAPE;
    final KeyStroke cancelStroke = KeyStroke.getKeyStroke(esc, 0);
    final String actionMapKey = cancelStroke.toString();
    inputMap.put(cancelStroke, actionMapKey);
    actionMap.put(actionMapKey, cancelAction);
  }

  /**
   * Construo da janela
   */
  private void build() {
    setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    DesktopFrame desktopFrame = DesktopFrame.getInstance();
    if (desktopFrame != null) {
      desktopFrame.addWindow(this);
    }
  }

  /**
   * Centralizao
   */
  public void center() {
    this.center(getOwner());
  }

  /**
   * Centralizao
   *
   * @param window a janela de referncia para centralizao
   */
  public void center(Window window) {
    if (window == null) {
      GUIUtils.centerOnScreen(this);
      return;
    }

    if (window instanceof JFrame) {
      // getSize(), getX() e getY() no levam em considerao o fato da janela
      // de referncia estar maximizada; neste caso, centralizamos na tela.
      JFrame jframe = (JFrame) window;
      final int windowState = jframe.getExtendedState();
      if ((windowState & Frame.MAXIMIZED_BOTH) != 0) {
        GUIUtils.centerOnScreen(this);
        return;
      }
    }
    Dimension currentSize = this.getSize();
    Dimension windowSize = window.getSize();
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    int minX = window.getX() + (windowSize.width - currentSize.width) / 2;
    if ((minX + currentSize.width) > screenSize.width) {
      minX = screenSize.width - currentSize.width;
    }
    if (minX < 0) {
      minX = 0;
    }
    int minY = window.getY() + (windowSize.height - currentSize.height) / 2;
    if ((minY + currentSize.height) > screenSize.height) {
      minY = screenSize.height - currentSize.height;
    }
    if (minY < 0) {
      minY = 0;
    }
    this.setLocation(minX, minY);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void close() {
    DesktopFrame desktopFrame = DesktopFrame.getInstance();
    if (desktopFrame != null) {
      desktopFrame.removeWindow(this);
    }

    dispose();
  }

  /**
   * Construtor
   *
   * @param owner frame pai. Caso seja <code>NULL</code>, o owner ser a
   *        interface principal do sistema ou nenhum se no existir
   *        {@link DesktopFrame} instanciado.
   */
  public DesktopComponentDialog(Window owner) {
    this(owner, null);
  }

  /**
   * Construtor
   *
   * @param owner frame pai. Caso seja <code>NULL</code>, o owner ser a
   *        interface principal do sistema ou nenhum se no existir
   *        {@link DesktopFrame} instanciado.
   * @param title ttulo
   */
  public DesktopComponentDialog(Window owner, String title) {
    super(owner == null ? (DesktopFrame.getInstance() == null ? null
      : DesktopFrame.getInstance().getDesktopFrame()) : owner, title,
      Dialog.DEFAULT_MODALITY_TYPE);
    build();
    addEscListener();
  }
}
