package csbase.client.preferences.editors;

import java.awt.Dimension;
import java.awt.GridBagLayout;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import tecgraf.javautils.gui.GBC;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;

/**
 * Classe que encapsula a edio de um objeto do tipo {@link Dimension}.
 * 
 * @author Tecgraf
 */
public class PVDimensionEditor extends PreferenceEditor<Dimension> {

  /**
   * Construtor padro.
   * 
   * @param pv objeto que encapsula o valor da preferncia.
   */
  public PVDimensionEditor(PreferenceValue<Dimension> pv) {
    super(pv);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createComponent() {
    Dimension dimension = getValue();

    final SpinnerNumberModel width =
      new SpinnerNumberModel(dimension.width, 0, Integer.MAX_VALUE, 1);

    final SpinnerNumberModel height =
      new SpinnerNumberModel(dimension.height, 0, Integer.MAX_VALUE, 1);

    width.addChangeListener(new ChangeListener() {
      @Override
      public void stateChanged(ChangeEvent e) {
        getValue().width = (Integer) width.getValue();
        notifyListeners();
      }
    });

    height.addChangeListener(new ChangeListener() {
      @Override
      public void stateChanged(ChangeEvent e) {
        getValue().height = (Integer) height.getValue();
        notifyListeners();
      }
    });

    JSpinner spinnerWidth = new JSpinner(width);
    spinnerWidth.setEnabled(isEditable());

    JSpinner spinnerHeight = new JSpinner(height);
    spinnerWidth.setEnabled(isEditable());

    JLabel x = new JLabel("X");
    x.setFont(font);

    JPanel panel = new JPanel(new GridBagLayout());
    panel.add(spinnerWidth, new GBC(0, 0));
    panel.add(x, new GBC(1, 0).insets(0, 5, 0, 5));
    panel.add(spinnerHeight, new GBC(2, 0));

    return panel;
  }
}
