package csbase.client.project.dialogs;

import java.util.Hashtable;

import javax.swing.JPanel;

/**
 * Classe a ser estendida por paineis que representem atributos de um projeto.
 * Seu contedo deve poder ser representado por uma {@link Hashtable} de Strings
 * em Strings.
 * 
 * @author jnlopes
 */
public abstract class ProjectDataExtensionPanel extends JPanel {

  /**
   * Retorna o contedo do painel na forma de uma hashtable de strings(chaves)
   * em strings(valores).
   * 
   * @return Contedo do painel na forma de uma hashtable de strings(chaves) em
   *         strings(valores).
   */
  public abstract Hashtable<String, Object> getPanelData();

  /**
   * Define o contedo do painel a partir dos dados.
   * 
   * @param data Dados que representam o contedo do painel.
   */
  public abstract void setPanelData(final Hashtable<String, Object> data);

}
