package csbase.client.util.csvpanel.columns;

import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.util.csvpanel.columns.ClientFileChooserTextPanel.ClientFileLocation;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.logic.ClientFile;

/**
 * O dilogo de configurao do gerador sequencial de valores
 * {@link SequentialColumnGenerator}.
 */
public class DirectoryListingColumnGeneratorDialog extends
  DesktopComponentDialog {

  /**
   * O gerador a ser configurado.
   */
  private DirectoryListingColumnGenerator generator;

  /**
   * Indica se a operao de configuranao do gerador foi confirmada.
   */
  private boolean confirmed;

  /**
   * Painel de escolha de diretrio de listagem.
   */
  private ClientFileChooserTextPanel directoryChooserPanel;

  /**
   * Construtor.
   * 
   * @param owner a janela-me do dilogo.
   */
  public DirectoryListingColumnGeneratorDialog(Window owner) {
    super(owner, getString("title"));
    this.confirmed = false;
    setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    generator = null;
    createUI();
  }

  /**
   * Monta os componentes grficos do dilogo.
   */
  private void createUI() {
    JPanel mainPanel = createMainPanel();
    JPanel buttonPanel = createButtonPanel();
    add(mainPanel, BorderLayout.CENTER);
    add(buttonPanel, BorderLayout.SOUTH);
    center();
    pack();
  }

  /**
   * Cria o painel principal do dilogo.
   * 
   * @return o painel.
   */
  private JPanel createMainPanel() {
    JPanel mainPanel = new JPanel();
    JLabel directoryLabel = new JLabel(getString("dir.label"));
    directoryChooserPanel =
      new ClientFileChooserTextPanel(this, null, ClientFileChooserType.OPEN,
        ClientFileChooserSelectionMode.DIRECTORIES_ONLY, ClientFileLocation.ANY);
    mainPanel.add(directoryLabel, BorderLayout.LINE_START);
    mainPanel.add(directoryChooserPanel, BorderLayout.LINE_END);
    return mainPanel;
  }

  /**
   * Cria o painel de botes do dilogo.
   * 
   * @return o painel.
   */
  private JPanel createButtonPanel() {
    JButton okButton = new JButton(getString("ok.button"));
    okButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        if (applyValues()) {
          confirmed = true;
          setVisible(false);
        }
      }
    });
    JButton cancelButton = new JButton(getString("cancel.button"));
    cancelButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        confirmed = false;
        setVisible(false);
      }
    });

    JPanel buttonPanel = new JPanel();
    buttonPanel.add(okButton, BorderLayout.LINE_START);
    buttonPanel.add(cancelButton, BorderLayout.LINE_END);
    return buttonPanel;
  }

  /**
   * Aplica e valida os valores escolhidos pelo usurio.
   * 
   * @return verdadeiro se os valores foram aplicados corretamente ou falso,
   *         caso contrrio.
   */
  private boolean applyValues() {
    ClientFile directory = directoryChooserPanel.getSelectedFile();
    if (directory != null) {
      generator = new DirectoryListingColumnGenerator(this, directory);
    }
    return true;
  }

  /**
   * Obtm a string localizada da chave de internacionalizao especificada.
   * 
   * @param key a chave de internacionalizao.
   * @return a string localizada.
   */
  protected static String getString(String key) {
    return LNG.get(DirectoryListingColumnGeneratorDialog.class.getName() + "."
      + key);
  }

  /**
   * Obtm a string localizada da chave de internacionalizao especificada.
   * 
   * @param key a chave de internacionalizao.
   * @param args lista de parmetros para formatao da string.
   * @return a string localizada.
   */
  protected static String getString(String key, Object... args) {
    return MessageFormat.format(getString(key), args);
  }

  /**
   * Obtm o gerados de coluna configurado pelo usurio.
   * 
   * @return o gerador de coluna ou falso, caso no seja confirmada a operao.
   */
  public ColumnGenerator<?> getColumnGenerator() {
    if (!confirmed) {
      return null;
    }
    return generator;
  }

}
