/*
 * $Id$
 */
package csbase.client.util.gui.log.enums;

import csbase.client.util.gui.log.LogPanel;

/**
 * @author Tecgraf/PUC-Rio
 */
public enum FontType {

  /**
   * Serifada (Java built-in)
   */
  SERIF("serif"),

  /**
   * Sem serifa (Java built-in)
   */
  SAN_SERIF("sanserif"),

  /**
   * Verdana (Windows)
   */
  VERDANA("verdana"),

  /**
   * Monoespaada (Java built-in)
   */
  MONOSPACED("monospaced");

  /**
   * Nome do tipo
   */
  private final String typeName;

  /**
   * Consulta o nome do tipo.
   * 
   * @return o nome do tipo
   */
  public final String getTypeName() {
    return typeName;
  }

  /**
   * Consulta o nome da fonte (traduzida)
   * 
   * @return o texto
   */
  public final String getLabel() {
    String key = String.format("%s.%s", getClass().getSimpleName(), name());
    return LogPanel.getString(key);
  }

  /**
   * Construtor
   * 
   * @param typeName o nome do tipo.
   */
  private FontType(final String typeName) {
    this.typeName = typeName;
  }

  /**
   * Consulta uma fonte com base no nome.
   * 
   * @param name o nome
   * @return a fonte
   */
  public static FontType getFontTypeByName(String name) {
    for (final FontType tp : values()) {
      if (tp.getTypeName().equals(name))
        return tp;
    }
    return null;
  }
}
