package csbase.client.util.xmlpanel.xmlattributetablepanel;

import java.util.List;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import org.w3c.dom.Node;

import csbase.client.util.xmlpanel.XMLPanelUtils;

/**
 * Modelo bsico.
 * 
 * @author Tecgraf/PUC-Rio
 */
class XMLAttributeTableModel implements TableModel {
  /**
   * N do modelo.
   */
  final private Node node;

  /**
   * Lista de filhos.
   */
  final private List<Node> children;

  /**
   * Texto de colunas
   */
  final private String[] columnTexts;

  /**
   * {@inheritDoc}
   */
  @Override
  public void addTableModelListener(TableModelListener l) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<String> getColumnClass(int columnIndex) {
    return String.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getColumnCount() {
    return 2;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName(int columnIndex) {
    if (columnIndex >= columnTexts.length) {
      return "???";
    }
    return columnTexts[columnIndex];
  }

  /**
   * Consulta n do modelo de tabela.
   * 
   * @return n
   */
  public Node getNode() {
    return node;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getRowCount() {
    if (children == null) {
      return 0;
    }
    return children.size();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getValueAt(int rowIndex, int columnIndex) {
    if (children == null || children.size() == 0) {
      return null;
    }
    final Node attribute = children.get(rowIndex);
    if (attribute == null) {
      return null;
    }
    if (columnIndex == 0) {
      return attribute.getNodeName();
    }
    else if (columnIndex == 1) {
      return attribute.getNodeValue();
    }
    return "!!!";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isCellEditable(int rowIndex, int columnIndex) {
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void removeTableModelListener(TableModelListener l) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
  }

  /**
   * Construtor
   * 
   * @param node n.
   * @param columnTexts texto das colunas.
   */
  public XMLAttributeTableModel(Node node, String[] columnTexts) {
    this.node = node;
    this.children = XMLPanelUtils.getAttributeChildren(node);
    this.columnTexts = columnTexts;
  }
}