package csbase.client.util.xmlpanel.xmlattributetablepanel;

import java.awt.BorderLayout;

import javax.swing.JScrollPane;
import javax.swing.JTable;

import org.w3c.dom.Node;

import csbase.client.util.xmlpanel.XMLAbstractPanel;

/**
 * Painel de tabela de atributos de tags XML.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class XMLAttributeTablePanel extends XMLAbstractPanel {

  /**
   * Tabela interna do painel.
   */
  final private JTable jtable = new JTable();

  /**
   * Consulta textos de colunas.
   * 
   * @return textos
   */
  private String[] getColumnTexts() {
    final String valText = getString("value.column");
    final String nameText = getString("name.column");
    final String[] columnTexts = new String[] { nameText, valText };
    return columnTexts;
  }

  /**
   * Ajuste de n da rvore.
   * 
   * @param node n
   */
  @Override
  public void setNode(Node node) {
    internalSetNode(node);
    final String[] columnTexts = getColumnTexts();
    final XMLAttributeTableModel model =
      new XMLAttributeTableModel(node, columnTexts);
    jtable.setModel(model);
  }

  /**
   * Construtor
   */
  public XMLAttributeTablePanel() {
    final String[] columnTexts = getColumnTexts();
    jtable.setModel(new XMLAttributeTableModel(null, columnTexts));
    jtable.setDefaultRenderer(String.class, new XMLAttributeTableRenderer());
    final JScrollPane scrollPane = new JScrollPane(jtable);
    setLayout(new BorderLayout());
    add(scrollPane, BorderLayout.CENTER);
  }
}
