/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.usersearch;

import csbase.client.applications.projectsmanager.usersearch.UserPanel;
import csbase.logic.UserOutline;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class UserDialog
extends JDialog {
    private boolean userConfirmed;
    private boolean isClosed;
    private final boolean confirmation;
    private Set<Object> selectedUsers;
    protected final UserPanel userPanel;

    public UserDialog(Window owner, List<UserOutline> allUsers, boolean showPermissions, boolean confirmation) {
        super(owner);
        this.confirmation = confirmation;
        this.userPanel = this.getUserPanel(allUsers, showPermissions);
    }

    public UserDialog(Window owner, List<UserOutline> allUsers, Set<Object> usersRO, Set<Object> usersRW, boolean showPermissions, boolean confirmation) {
        super(owner);
        this.confirmation = confirmation;
        this.userPanel = this.getUserPanel(allUsers, usersRO, usersRW, showPermissions);
    }

    public UserDialog(Window owner, List<UserOutline> allUsers, Set<Object> usersRO, Set<Object> usersRW, boolean showPermissions, boolean confirmation, boolean fixedAccess) {
        super(owner);
        this.confirmation = confirmation;
        this.userPanel = this.getUserPanel(allUsers, usersRO, usersRW, showPermissions, fixedAccess);
    }

    protected UserPanel getUserPanel(List<UserOutline> allUsers, Set<Object> usersRO, Set<Object> usersRW, boolean showPermissions, boolean fixedAccess) {
        return new UserPanel(allUsers, usersRO, usersRW, showPermissions, fixedAccess);
    }

    protected UserPanel getUserPanel(List<UserOutline> allUsers, Set<Object> usersRO, Set<Object> usersRW, boolean showPermissions) {
        return new UserPanel(allUsers, usersRO, usersRW, showPermissions);
    }

    protected UserPanel getUserPanel(List<UserOutline> allUsers, boolean showPermissions) {
        return new UserPanel(allUsers, showPermissions);
    }

    public static void showUserListDialog(JFrame frame, List<UserOutline> rawUsers) {
        String title = LNG.get((String)"UserDialog.users.title");
        UserDialog ud = new UserDialog((Window)frame, rawUsers, false, false);
        ud.setTitle(title);
        ud.execute();
    }

    public static void showProjectUsersDialog(JFrame frame, List<UserOutline> rawUsers, Set<Object> usersRO, Set<Object> usersRW) {
        UserDialog ud = new UserDialog(frame, rawUsers, usersRO, usersRW, true, false, true);
        ud.setTitle(LNG.get((String)"UserDialog.project.users.title"));
        ud.userPanel.enableSharedUsersPanel(false);
        ud.execute();
    }

    public static Set<Object> showUserSelectionDialog(Window owner, List<UserOutline> rawUsers, boolean multipleSelection, String title) {
        UserDialog ud = new UserDialog(owner, rawUsers, false, true);
        ud.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        ud.userPanel.setTableSelection(multipleSelection);
        ud.setTitle(title);
        ud.execute();
        return ud.getSelectedUsers();
    }

    public Set<Object> getSelectedUsers() {
        return this.selectedUsers;
    }

    protected void createGUI() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UserDialog.this.cancel();
            }
        });
        this.setLayout(new GridBagLayout());
        int y = this.addInputPanels(0);
        JPanel buttonsPanel = this.createButtonsPanel();
        GBC gbc = new GBC(0, y + 1).northwest().bottom(5).horizontal();
        this.add((Component)buttonsPanel, gbc);
    }

    private int addInputPanels(int ypos) {
        int y = ypos;
        GBC gbc = new GBC(0, y++).both().insets(10);
        this.add((Component)this.userPanel, gbc);
        return y;
    }

    private JPanel createButtonsPanel() {
        JPanel panel = new JPanel();
        if (!this.confirmation) {
            JButton closeButton = new JButton(LNG.get((String)"UserDialog.button.ok"));
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDialog.this.dispose();
                }
            });
            panel.add(closeButton);
            return panel;
        }
        JButton confirmButton = new JButton(LNG.get((String)"UserDialog.button.confirm"));
        confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UserDialog.this.canConfirm()) {
                    UserDialog.this.confirm();
                }
            }
        });
        JButton cancelButton = new JButton(LNG.get((String)"UserDialog.button.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDialog.this.cancel();
            }
        });
        JComponent[] buttons = new JButton[]{confirmButton, cancelButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        panel.add(confirmButton);
        panel.add(cancelButton);
        return panel;
    }

    protected void confirm() {
        this.userConfirmed = true;
        this.selectedUsers = this.userPanel.getSelectedUsers();
        this.userPanel.fillUserSets();
        this.close();
    }

    private boolean canConfirm() {
        return true;
    }

    private void cancel() {
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.isClosed = true;
    }

    public boolean execute() {
        this.createGUI();
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setSize(new Dimension(500, 400));
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
        return this.userConfirmed;
    }

    public Set<Object> getUsersRO() {
        this.checkIsClosed();
        return this.userPanel.getUsersRO();
    }

    private void checkIsClosed() {
        if (!this.isClosed) {
            throw new IllegalStateException("close() deveria ter sido chamado");
        }
    }

    public boolean wasConfirmed() {
        return this.userConfirmed;
    }

    public Set<Object> getUsersRW() {
        this.checkIsClosed();
        return this.userPanel.getUsersRW();
    }
}

