/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table;

import java.util.List;

import tecgraf.javautils.gui.table.ModifiableObjectTableProvider;
import csbase.client.applications.commandsmonitor.table.column.AbstractCommandsTableColumn;
import csbase.client.facilities.commandtable.CommandMonitoringSet;

/**
 * Interface que estende a <code>ModifiableObjectTableProvider</code>,
 * permitindo ao desenvolvedor criar uma tabela de comandos, editvel. Os
 * mtodos dessa interface indicam quais clulas podem ser editadas (
 * <code>isCellEditable(int,int)</code>) e como deve ser feita a edio no
 * objeto que representa uma linha da tabela (
 * <code>setValueAt(Object, Objec,t int)</code>).
 * 
 * @author Tecgraf / PUC-Rio
 */
class CommandsTableProvider implements
  ModifiableObjectTableProvider<CommandMonitoringSet> {

  /** Lista das colunas da tabela. */
  private List<AbstractCommandsTableColumn> columns;

  /**
   * Construtor.
   * 
   * @param columns colunas da tabela.
   */
  public CommandsTableProvider(List<AbstractCommandsTableColumn> columns) {
    this.columns = columns;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?>[] getColumnClasses() {

    Class<?>[] classes = new Class[columns.size()];
    for (int inx = 0; inx < columns.size(); inx++) {
      classes[inx] = columns.get(inx).getColumnClass();
    }

    return classes;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String[] getColumnNames() {
    String[] names = new String[columns.size()];
    for (int inx = 0; inx < columns.size(); inx++) {
      names[inx] = columns.get(inx).getColumnName();
    }

    return names;
  }
  
  /**
   * {@inheritDoc}
   */
  @Override
  public Object getCellValue(CommandMonitoringSet row, int col) {
    return columns.get(col).getValue(row.getCommandInfo());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isCellEditable(int rowIndex, int columnIndex) {
    return columns.get(columnIndex).isColumnEditable();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setValueAt(CommandMonitoringSet row, Object newValue, int colIndex) {
    columns.get(colIndex).setValue(row.getCommandInfo(), newValue);
  }
}
