/*
 * $Id: RootRemoteAction.java 88758 2009-02-27 21:57:35Z clinio $
 */

package csbase.client.applications.filetransferclient.actions;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.remotepanel.FileTransferClientRemotePanel;

/**
 * @author Tecgraf/PUC-Rio
 */
public class RootRemoteAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(final JComponent component) {
    final FileTransferClient app = getApplication();
    final FileTransferClientRemotePanel remotePanel = app.getRemotePanel();
    final String path = FileTransferClientRemotePanel.ROOT_REMOTE_PATH;
    remotePanel.setRemoteDirectory(path);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public RootRemoteAction(final FileTransferClient application) {
    super(application);
  }

}
