package csbase.client.csdk.v2.eventlog;

import java.util.Date;

import csbase.client.csdk.v2.core.CSDKAbstractContext;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.logic.eventlogservice.LogsInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.EventLogServiceInterface;
import csdk.v2.extras.context.EventLogException;
import csdk.v2.extras.context.IEventLogContext;
import csdk.v2.extras.context.ILogsInfo;
import tecgraf.javautils.core.lng.LNG;

/**
 * Contexto que fornecer acesso ao Servio de Logs de Eventos.
 * 
 * @author Tecgraf
 */
public class EventLogContext extends CSDKAbstractContext implements
  IEventLogContext {

  /**
   * Mtodo para chamada ao servio <code>EventLogService</code> a partir do
   * cliente, que pesquisa logs conforme parmetros recebidos. Nos casos de
   * erro, a exceo  capturada e exibida ao usurio.
   * 
   * @param queues filas de armazenamento desejadas
   * @param startDate data inicial da busca
   * @param endDate data final da busca
   * 
   * @return resultado com as estatsticas relacionadas a pesquisa.
   */
  @Override
  public ILogsInfo find(final String[][] queues, final Date startDate,
    final Date endDate) throws EventLogException {

    if (!ClientRemoteMonitor.getInstance().isAlive()) {
      throw new EventLogException(LNG.get("eventlog.msg.no_server"));
    }

    final EventLogServiceInterface eventLogService =
      ClientRemoteLocator.eventLogService;

    final DesktopFrame mainFrame = DesktopFrame.getInstance();
    if ((mainFrame == null) || (eventLogService == null)) {
      throw new EventLogException(LNG.get("eventlog.msg.no_server"));
    }

    final RemoteTask<ILogsInfo> task = new RemoteTask<ILogsInfo>() {
      @Override
      public void performTask() throws Exception {
        LogsInfo info = eventLogService.find(queues, startDate, endDate);
        setResult(new CSDKLogsInfo(info));
      }
    };

    final String msg = LNG.get("eventlog.msg.reading_data");
    final String title = LNG.get("eventlog.title");
    if (task.execute(mainFrame.getDesktopFrame(), title, msg)) {
      return task.getResult();
    }

    // resultado vazio
    return new CSDKLogsInfo(new LogsInfo(startDate, endDate));
  }

}
