package csbase.client.rest;

/**
 * Created by Tiago on 21/10/2016.
 */
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

/**
 * Classe para debugar problemas em modo desevolvedor
 */
@Provider
public class DebugMapper implements ExceptionMapper<Throwable>  {

    @Override
    public Response toResponse(Throwable exception) {
        exception.printStackTrace();
        if (exception instanceof WebApplicationException) {
            return ((WebApplicationException)exception).getResponse();
        }
        return Response.serverError().entity(exception.getMessage()).build();
    }
}