package csbase.client.csdk.v2.filesystem;

import java.awt.Window;

import csbase.client.project.ClientFileLock;
import csdk.v2.api.filesystem.IFile;
import csdk.v2.api.filesystem.IFileLock;

/**
 * Representa um lock de um {@link IFile arquivo} de projeto.
 */
public class CSDKProjectFileLock implements IFileLock {

  /**
   * Lock do arquivo.
   */
  private ClientFileLock lock;

  /**
   * Construtor.
   * 
   * @param lock lock do arquivo.
   */
  public CSDKProjectFileLock(ClientFileLock lock) {
    this.lock = lock;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public LockStatus getLockStatus() {
    switch (lock.getLockStatus()) {
      case LOCK_DENIED:
        return LockStatus.LOCK_DENIED;
      case LOCK_EXCLUSIVE:
        return LockStatus.LOCK_EXCLUSIVE;
      case LOCK_RELEASED:
        return LockStatus.LOCK_RELEASED;
      case LOCK_SHARED:
        return LockStatus.LOCK_SHARED;
      default:
        return null;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void releaseLock(Window window) {
    lock.releaseLock(window);
  }

}
