package csbase.client.project;

import java.util.Hashtable;
import java.util.Vector;

import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

/**
 * Sub-classe de JPopupMenu, que armazena em uma Hashtable os itens de menu
 * adicionados. Possui mtodos para retornar esses itens.
 */
public class ProjectTreePopupMenu extends JPopupMenu {

  /**
   * Para armazenar os itens de menu. Com garantia de retornar na ordem de
   * insero
   */
  private Hashtable<String, JComponent> items;
  /** Sequencial para gerar a chave de separadores de itens de menu */
  private int sepSeq = 1;
  /** Vetor para armazenar chaves de cada item, na ordem de insero */
  private Vector<String> vetKeys;

  /**
   * Construtor
   */
  public ProjectTreePopupMenu() {
    super();
    items = new Hashtable<String, JComponent>();
    vetKeys = new Vector<String>();
  }

  /**
   * Redefinio do mtodo add(JMenuItem menuItem) Armazena o item de menu em
   * uma Hashtable com chave igual ao texto do JMneuItem.
   */
  @Override
  public JMenuItem add(JMenuItem menuItem) {
    super.add(menuItem);
    items.put(menuItem.getText(), menuItem);
    vetKeys.add(menuItem.getText());
    return menuItem;
  }

  /**
   * Appends a new separator at the end of the menu.
   */
  @Override
  public void addSeparator() {
    JSeparator sep = new JPopupMenu.Separator();
    add(sep);
    String sepKey = "sep" + String.valueOf(sepSeq++);
    items.put(sepKey, sep);
    vetKeys.add(sepKey);
  }

  /**
   * Torna invisivel o Item de Menu com chave itemText. Se no encontrar o item,
   * no faz nada.
   * 
   * @param itemText chave para identifio do item de menu.
   * @param visible booleano que indica o novo estado de visibilidade do item de
   *        menu.
   */
  public void setItemVisible(String itemText, boolean visible) {
    if (items.containsKey(itemText)) {
      ((JMenuItem) (getItem(itemText))).setVisible(visible);
    }
  }

  /**
   * Remove o Item de Menu com chave itemText. Se no encontrar o item, no faz
   * nada.
   * 
   * @param itemText chave para identifio do item de menu.
   */
  public void removeItem(String itemText) {

    // Se item no for um separador, entra em removeSeparators
    if (!itemText.substring(0, 3).equals("sep")) {
      removeSeparators(itemText);
    }

    if (items.containsKey(itemText)) {
      // Removendo o item de menu
      remove(getItem(itemText));
      // Removendo o item da Hashtable
      items.remove(itemText);
      // Removendo a chave do Vetor de chaves
      vetKeys.remove(itemText);
    }
  }

  /**
   * Verifica se  preciso remover algum separador. Se for preciso, remove.
   * 
   * @param itemText chave para identifio do item de menu a ser verificado.
   */
  private void removeSeparators(String itemText) {
    // Percorrendo o vetor de chaves
    for (int i = 0; i < vetKeys.size(); i++) {
      String key = vetKeys.get(i);
      if (key.equals(itemText)) {
        if (i == 0) { //  o primeiro
          if (i < vetKeys.size() - 1) { // No  o ltimo
            String keyProx = (vetKeys.get(i + 1));
            // Testando se o prximo  um separador
            if (keyProx.substring(0, 3).equals("sep")) {
              removeItem(keyProx);
            }
          }
        }
        else if (i == (vetKeys.size() - 1)) { //  o ltimo
          String keyAnt = (vetKeys.get(i - 1));
          // Testando se o anterior  um separador
          if (keyAnt.substring(0, 3).equals("sep")) {
            removeItem(keyAnt);
          }
        }
        // Testando se est entre separadores
        else {
          String keyProx = (vetKeys.get(i + 1));
          String keyAnt = (vetKeys.get(i - 1));
          if (keyProx.substring(0, 3).equals("sep") && keyAnt.substring(0, 3)
            .equals("sep")) {
            removeItem(keyProx);
          }
        }
        break;
      }
    }
  }

  /**
   * Retorna os itens de menu em uma Hashtable.
   * 
   * @return itens de menu.
   */
  public Hashtable<String, JComponent> getItems() {
    return items;
  }

  /**
   * Retorna um item de menu pela chave.
   * 
   * @param key a chave.
   * @return item de menu.
   */
  public JComponent getItem(String key) {
    return items.get(key);
  }

}
