package csbase.client.applications.algorithmsmanager.report.implementations;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import csbase.client.applications.algorithmsmanager.report.core.AbstractTest;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import tecgraf.javautils.core.lng.LNG;

/**
 * Classe que testa se um parmetro est sendo usado por algum teste;
 *
 * @author Tecgraf/PUC-Rio
 */
public class TestParameterUsage extends AbstractTest<ParameterStructure> {

  /**
   * Lista dos algorithmos que deve ser varrida para encontrar algum que use o
   * parmetro
   */
  private final SimpleConfiguratorSource algorithms;

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return LNG.get("TestParameterUsage.name");
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getDescription() {
    return LNG.get("TestParameterUsage.description");
  }

  /**
   * Construtor
   *
   * @param algorithms Lista de algoritmos
   * @param window janela que disparou o teste
   */
  public TestParameterUsage(SimpleConfiguratorSource algorithms,
    Window window) {
    super(window, LNG.get("TestParameterUsage.task.title"),
      LNG.get("TestParameterUsage.task.message"));
    this.algorithms = algorithms;

  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<ParameterStructure> getSubjectClass() {
    return ParameterStructure.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected List<IResultMessage<ParameterStructure>> doTest(
    ParameterStructure subject) {
    List<IResultMessage<ParameterStructure>> resultMessages = new ArrayList<>();
    Class<?> elementClass = subject.getElementClass();
    if (SimpleParameter.class.isAssignableFrom(elementClass)) {

      for (SimpleAlgorithmConfigurator configurator : algorithms) {
        List<SimpleParameter<?>> parameters =
          configurator.getSimpleParameters();
        Optional<? extends Class<? extends SimpleParameter>> hasParameter =
          parameters.stream().map(SimpleParameter::getClass)
            .filter(elementClass::equals).findAny();

        if (hasParameter.isPresent()) {
          String message = LNG.get("TestParameterUsage.result.used",
            configurator.getAlgorithmName());
          IResultMessage<ParameterStructure> resultMessage =
            new ResultMessage<>(subject, TestStatus.OK, message);
          resultMessages.add(resultMessage);
        }
      }

      if (resultMessages.isEmpty()) {
        IResultMessage<ParameterStructure> resultMessage =
          new ResultMessage<>(subject, TestStatus.ERROR,
            LNG.get("TestParameterUsage.result.not.used"));
        resultMessages.add(resultMessage);
      }
    }
    return resultMessages;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getSubjectName(ParameterStructure subject) {
    return subject.getElementClass().getSimpleName();
  }
}
