/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import tecgraf.javautils.core.timestamp.TStamp32;

public abstract class ApplicationType
extends Observable {
    private static final String RES_DIR_NAME = "resources";
    private ApplicationRegistry applicationRegistry = null;
    private final String instanceId;

    protected final void launchApplication() throws ApplicationException {
        this.startApplication();
    }

    public final List<String> getFileTypes() {
        return this.applicationRegistry.getFileTypes();
    }

    protected final ApplicationRegistry getApplicationRegistry() {
        return this.applicationRegistry;
    }

    public final String getId() {
        return this.applicationRegistry.getId();
    }

    public final String getInstanceId() {
        return this.instanceId;
    }

    public final int getInstanceIndex() {
        ApplicationManager appManager = ApplicationManager.getInstance();
        int id = appManager.getInstanceIndex(this);
        return id;
    }

    public final ImageIcon getImageIcon() {
        byte[] imgDef = this.applicationRegistry.getImageDefinition();
        if (imgDef == null) {
            return null;
        }
        return new ImageIcon(imgDef);
    }

    public final String getName() {
        ApplicationManager appManager = ApplicationManager.getInstance();
        return appManager.getApplicationName(this.applicationRegistry);
    }

    public final int getVersionNumber() {
        return this.applicationRegistry.getVersionNumber();
    }

    public final String getVersion() {
        return this.applicationRegistry.getVersion();
    }

    public final String getAuthorMail() {
        return this.applicationRegistry.getAuthorMail();
    }

    public final String getAuthorName() {
        return this.applicationRegistry.getAuthorName();
    }

    public final String getDescription() {
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        return applicationManager.getApplicationDescription(this.applicationRegistry);
    }

    protected ApplicationType(String id) {
        this.instanceId = this.generateInstanceId(id);
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        this.applicationRegistry = applicationManager.getApplicationRegistry(id);
    }

    private String generateInstanceId(String appId) {
        TStamp32 idSuffix = new TStamp32();
        return appId + "_" + idSuffix;
    }

    public final int getIntSpecificProperty(String propName, int defaultValue) {
        if (this.applicationRegistry.isPropertyNull(propName)) {
            return defaultValue;
        }
        return this.applicationRegistry.getIntSpecificProperty(propName);
    }

    public final long getLongSpecificProperty(String propName, long defaultValue) {
        if (this.applicationRegistry.isPropertyNull(propName)) {
            return defaultValue;
        }
        return this.applicationRegistry.getLongSpecificProperty(propName);
    }

    public final int getLongSpecificProperty(String propName, int defaultValue) {
        if (this.applicationRegistry.isPropertyNull(propName)) {
            return defaultValue;
        }
        return this.applicationRegistry.getIntSpecificProperty(propName);
    }

    public final String getStringSpecificProperty(String propName) {
        return this.applicationRegistry.getStringSpecificProperty(propName);
    }

    public final String getStringSpecificProperty(String propName, String defaultValue) {
        if (this.applicationRegistry.isPropertyNull(propName)) {
            return defaultValue;
        }
        return this.applicationRegistry.getStringSpecificProperty(propName);
    }

    public final List<String> getStringListSpecificProperty(String propName) {
        return this.applicationRegistry.getStringListSpecificProperty(propName);
    }

    public final boolean getBooleanSpecificProperty(String propName, boolean defaultValue) {
        if (this.applicationRegistry.isPropertyNull(propName)) {
            return defaultValue;
        }
        return this.applicationRegistry.getBooleanSpecificProperty(propName);
    }

    public final double getDoubleSpecificProperty(String propName, double defaultValue) {
        if (this.applicationRegistry.isPropertyNull(propName)) {
            return defaultValue;
        }
        return this.applicationRegistry.getDoubleSpecificProperty(propName);
    }

    @Deprecated
    public void sendMessage(String name, Object value, String senderId) {
    }

    protected void onAsyncMessageReceived(String type, Object value, String senderId) {
    }

    protected Object onSyncMessageReceived(String type, Object value, String senderId) {
        return null;
    }

    public void postInitialization() throws ApplicationException {
    }

    public abstract void killApplication() throws ApplicationException;

    public abstract void startApplication() throws ApplicationException;

    public abstract void finishApplication();

    public final boolean closeApplication() {
        boolean canKill = this.userCanKillApplication();
        if (!canKill) {
            return false;
        }
        try {
            this.killApplication();
        }
        catch (Exception e) {
            this.showApplicationError(e);
        }
        this.finishApplication();
        return true;
    }

    private void showApplicationError(Throwable t) {
        ApplicationManager appManager = ApplicationManager.getInstance();
        Locale locale = appManager.getLocale();
        String title = this.applicationRegistry.getApplicationName(locale);
        JOptionPane.showMessageDialog(null, t.getMessage(), title, 0);
    }

    protected Class<?> getMainApplicationClass() {
        return this.getClass();
    }

    public static final ImageIcon getImageIcon(Class<?> baseClass, String imagePath) {
        String imgPath = "images/" + imagePath;
        try {
            URL url = ApplicationType.getApplicationResourceAsURL(baseClass, imgPath);
            if (url == null) {
                return null;
            }
            return new ImageIcon(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final URL getApplicationResourceAsURL(Class<?> baseClass, String path) {
        String resourcePath = "resources/" + path;
        URL url = baseClass.getResource(resourcePath);
        return url;
    }

    public static final InputStream getApplicationResourceAsStream(Class<?> baseClass, String path) {
        String resourcePath = "resources/" + path;
        InputStream stream = baseClass.getResourceAsStream(resourcePath);
        return stream;
    }

    public final ImageIcon getImageIcon(String imagePath) {
        return ApplicationType.getImageIcon(this.getMainApplicationClass(), imagePath);
    }

    public final URL getApplicationResourceAsURL(String path) {
        return ApplicationType.getApplicationResourceAsURL(this.getMainApplicationClass(), path);
    }

    public final InputStream getApplicationResourceAsStream(String path) {
        return ApplicationType.getApplicationResourceAsStream(this.getMainApplicationClass(), path);
    }

    protected abstract boolean userCanKillApplication();
}

